﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx/gfx_Types.h>
#include <nn/gfx/gfx_ResShader.h>

namespace nnt { namespace gfx { namespace util {

    class ResourceAllocator;

struct ResShader
{
    ptrdiff_t   binaryOffset;
    size_t      binarySize;

    nn::gfx::ResShaderFile* pResShaderFile;
    nn::gfx::ResShaderContainer* pResShaderContainer;
    nn::gfx::ShaderCodeType codeType;
};

void InitializeResShader(
    ResShader* pResShaderType, const void* pShaderDataBuffer, size_t shaderDataBufferSize,
    ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice);

void FinalizeResShader(
    ResShader* pResShaderType,
    ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice);

} } } // namespace nnt { namespace gfx { namespace util {
