﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfx/gfx_Types.h>
#include <nn/gfx/gfx_StateInfo.h>

#include "gfxUtilGpuBenchmark_ResourceAllocator.h"

namespace nnt { namespace gfx { namespace util {


class ResourceAllocator;

void InitializeTexture(
    nn::gfx::Texture* pTexture, const nn::gfx::Texture::InfoType& info,
    ResourceAllocator* pResourceAllocator, MemoryPoolType memoryPoolType,
    nn::gfx::Device* pDevice);
void InitializeTextureDisableFrameBufferCompression(
    nn::gfx::Texture* pTexture, const nn::gfx::Texture::InfoType& info,
    ResourceAllocator* pResourceAllocator, MemoryPoolType memoryPoolType,
    nn::gfx::Device* pDevice);
void FinalizeTexture(nn::gfx::Texture* pTexture,
    ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice);

void FillTextureWithColorPattern(
    nn::gfx::Texture* pTexture, const nn::gfx::Texture::InfoType& info,
    int randomSeed, ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice);

void InitializeBuffer(
    nn::gfx::Buffer* pBuffer, const nn::gfx::Buffer::InfoType& info,
    ResourceAllocator* pResourceAllocator, MemoryPoolType memoryPoolType,
    nn::gfx::Device* pDevice);
void FinalizeBuffer(nn::gfx::Buffer* pBuffer, ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice);
void ClearBufferContent(nn::gfx::Buffer* pBuffer, size_t bufferSize);
void CopyContentToBuffer(nn::gfx::Buffer* pBuffer, const void* pDataToCopy, size_t dataToCopySizeInBytes);

struct DefaultVertex
{
    float x;
    float y;
    float z;

    float u;
    float v;
};

extern const size_t g_RectangleVertexBufferDataSize;
void InitializeFullScreenQuadVertexBuffer(nn::gfx::Buffer* pBuffer, ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice);

void InitializeVertexBuffer(
    nn::gfx::Buffer* pBuffer, const void* pData, size_t dataSize,
    ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice);

void InitializeVertexState(
    nn::gfx::VertexState* pVertexState, const nn::gfx::VertexStateInfo& info,
    ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice);
void FinalizeVertexState(
    nn::gfx::VertexState* pVertexState,
    ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice);

size_t InitializeColorRenderTarget(
    nn::gfx::Texture* pTexture, nn::gfx::Buffer* pOutputCopyBuffer,
    nn::gfx::ColorTargetView* pColorTargetView, nn::gfx::ViewportScissorState* pViewportScissorState,
    int renderWidth, int renderHeight, nn::gfx::ImageFormat renderFormat, nn::gfx::TileMode tileMode,
    ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice);
size_t InitializeColorRenderTargetDisableFrameBufferCompression(
    nn::gfx::Texture* pTexture, nn::gfx::Buffer* pOutputCopyBuffer,
    nn::gfx::ColorTargetView* pColorTargetView, nn::gfx::ViewportScissorState* pViewportScissorState,
    int renderWidth, int renderHeight, nn::gfx::ImageFormat renderFormat, nn::gfx::TileMode tileMode,
    ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice);
void FinalizeColorRenderTarget(
    nn::gfx::Texture* pTexture, nn::gfx::Buffer* pOutputCopyBuffer,
    nn::gfx::ColorTargetView* pColorTargetView, nn::gfx::ViewportScissorState* pViewportScissorState,
    ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice);

void InitializeBlendState(
    nn::gfx::BlendState* pBlendState, nn::gfx::BlendStateInfo& info,
    ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice);
void FinalizeBlendState(
    nn::gfx::BlendState* pBlendState,
    ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice);


} } } // namespace nnt { namespace gfx { namespace util {
