﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>


// VisualStudioのpreprocessorのバッグの回避方法
// https://connect.microsoft.com/VisualStudio/feedback/details/380090/variadic-macro-replacement
#define EXPAND( x ) x

#define PARAM_COUNT_(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21, p22, p23, p24, p25, p26, p27, p28, p29, p30, p31, p32, p33, p34, p35, p36, p37, p38, p39, p40, v, ...) v
#define PARAM_COUNT(...) EXPAND(PARAM_COUNT_(__VA_ARGS__, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0))

#define CALL_SUBMACRO_DO_CALL(_a, ...) EXPAND(_a(__VA_ARGS__))
#define CALL_SUBMACRO_MERGE_NAME(_a, _b) _a ## _b
#define CALL_SUBMACRO(_a, _b, ...) CALL_SUBMACRO_DO_CALL(CALL_SUBMACRO_MERGE_NAME(_a, _b), __VA_ARGS__)

#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_2(n, v)            v
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_4(n, v, ...)       v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_2(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_6(n, v, ...)       v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_4(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_8(n, v, ...)       v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_6(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_10(n, v, ...)      v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_8(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_12(n, v, ...)      v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_10(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_14(n, v, ...)      v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_12(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_16(n, v, ...)      v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_14(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_18(n, v, ...)      v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_16(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_20(n, v, ...)      v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_18(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_22(n, v, ...)      v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_20(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_24(n, v, ...)      v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_22(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_26(n, v, ...)      v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_24(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_28(n, v, ...)      v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_26(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_30(n, v, ...)      v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_28(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_32(n, v, ...)      v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_30(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_34(n, v, ...)      v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_32(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_36(n, v, ...)      v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_34(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_38(n, v, ...)      v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_36(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_40(n, v, ...)      v, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_38(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES(...)               { CALL_SUBMACRO(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES_, PARAM_COUNT(__VA_ARGS__), __VA_ARGS__) }

#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_2(n, v)             n
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_4(n, v, ...)        n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_2(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_6(n, v, ...)        n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_4(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_8(n, v, ...)        n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_6(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_10(n, v, ...)       n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_8(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_12(n, v, ...)       n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_10(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_14(n, v, ...)       n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_12(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_16(n, v, ...)       n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_14(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_18(n, v, ...)       n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_16(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_20(n, v, ...)       n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_18(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_22(n, v, ...)       n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_20(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_24(n, v, ...)       n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_22(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_26(n, v, ...)       n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_24(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_28(n, v, ...)       n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_26(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_30(n, v, ...)       n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_28(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_32(n, v, ...)       n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_30(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_34(n, v, ...)       n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_32(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_36(n, v, ...)       n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_34(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_38(n, v, ...)       n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_36(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_40(n, v, ...)       n, EXPAND(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_38(__VA_ARGS__))
#define BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES(...)                { CALL_SUBMACRO(BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES_, PARAM_COUNT(__VA_ARGS__), __VA_ARGS__) }

#define BENCHMARK_PROPERTY_ENUM_VALUES(_enumType, ...)                                                                              \
    static const char* g_NameArray[] = BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_NAMES(__VA_ARGS__);                                 \
    static const int g_NameArrayCount = NN_ARRAY_SIZE(g_NameArray);                                                                     \
    static const _enumType g_ValueArray[] = BENCHMARK_PROPERTY_ENUM_VALUES_DEF_ARRAY_VALUES(__VA_ARGS__);                           \
    static const int g_ValueArrayCount = NN_ARRAY_SIZE(g_ValueArray);                                                                   \
    NN_STATIC_ASSERT(g_NameArrayCount == g_ValueArrayCount);

#define BENCHMARK_PROPERTY_INTEGER_RANGE_DEFINITION(_propertyPtr, _propertyName, _getterFunc, _setterFunc, _min, _max, _step)       \
    do {                                                                                                                            \
        static const GpuBenchmarkPropertyDefinitionIntegerRange g_PropertyDefinition(_propertyName, _min, _max, _step);             \
        _propertyPtr->Initialize(                                                                                                   \
            &g_PropertyDefinition, this,                                                                                            \
            &GetterWrapper<std::remove_reference<decltype(*this)>::type, &_getterFunc>,                                             \
            &SetterWrapper<std::remove_reference<decltype(*this)>::type, &_setterFunc>,                                             \
            nullptr);                                                                                                               \
        _propertyPtr->Set(_min);                                                                                                    \
    } while (false)

#define BENCHMARK_PROPERTY_INTEGER_RANGE_DEFINITION_INDEXED(_propertyPtr, _propertyName, _getterFunc, _setterFunc, _index, _min, _max, _step)   \
    do {                                                                                                                                        \
        static const GpuBenchmarkPropertyDefinitionIntegerRange g_PropertyDefinition(_propertyName, _min, _max, _step);                         \
        _propertyPtr->Initialize(                                                                                                               \
            &g_PropertyDefinition, this,                                                                                                        \
            &IndexedGetterWrapper<std::remove_reference<decltype(*this)>::type, decltype(_index), &_getterFunc, _index>,                        \
            &IndexedSetterWrapper<std::remove_reference<decltype(*this)>::type, decltype(_index), &_setterFunc, _index>,                        \
            nullptr);                                                                                                                           \
        _propertyPtr->Set(_min);                                                                                                                \
    } while (false)

#define BENCHMARK_PROPERTY_ENUM_DEFINITION(_propertyPtr, _propertyName, _enumType, _allocator, _getterFunc, _setterFunc, ...)                                \
    do {                                                                                                                                                \
        BENCHMARK_PROPERTY_ENUM_VALUES(_enumType, __VA_ARGS__);                                                                                         \
        static const GpuBenchmarkPropertyDefinitionEnum g_PropertyDefinition(_propertyName, g_NameArray, g_NameArrayCount);                             \
        SetterGetterEnumContext<std::remove_reference<decltype(*this)>::type, _enumType>* pSetterGetterEnumContext =                                    \
            InitializeSetterGetterEnumContext(this, _allocator, g_ValueArray, g_ValueArrayCount);                                                            \
        GpuBenchmarkPropertyHolder::GetterFunc pGetterFunc =                                                                                            \
            GetterEnumWrapper<std::remove_reference<decltype(*this)>::type, _enumType, &_getterFunc>;                                                   \
        GpuBenchmarkPropertyHolder::SetterFunc pSetterFunc =                                                                                            \
            SetterEnumWrapper<std::remove_reference<decltype(*this)>::type, _enumType, &_setterFunc>;                                                   \
        GpuBenchmarkPropertyHolder::ShutdownFunc pShutdownFunc =                                                                                        \
            ShutdownEnumWrapper< std::remove_reference<decltype(*this)>::type, _enumType>;                                                              \
        _propertyPtr->Initialize(&g_PropertyDefinition, pSetterGetterEnumContext, pGetterFunc, pSetterFunc, pShutdownFunc);                             \
        _propertyPtr->Set(0);                                                                                                                           \
    } while(false)

#define BENCHMARK_PROPERTY_ENUM_DEFINITION_INDEXED(_propertyPtr, _propertyName, _enumType, _indexType, _indexValue, _allocator, _getterFunc, _setterFunc, ...)       \
    do {                                                                                                                                                        \
        BENCHMARK_PROPERTY_ENUM_VALUES(_enumType, __VA_ARGS__);                                                                                                 \
        static const GpuBenchmarkPropertyDefinitionEnum g_PropertyDefinition(_propertyName, g_NameArray, g_NameArrayCount);                                     \
        SetterGetterEnumContext<std::remove_reference<decltype(*this)>::type, _enumType>* pSetterGetterEnumContext =                                            \
            InitializeSetterGetterEnumContext(this, _allocator, g_ValueArray, g_ValueArrayCount);                                                                    \
        GpuBenchmarkPropertyHolder::GetterFunc pGetterFunc =                                                                                                    \
            IndexedGetterEnumWrapper<std::remove_reference<decltype(*this)>::type, _enumType, _indexType, &_getterFunc, _indexValue>;                           \
        GpuBenchmarkPropertyHolder::SetterFunc pSetterFunc =                                                                                                    \
            IndexedSetterEnumWrapper<std::remove_reference<decltype(*this)>::type, _enumType, _indexType, &_setterFunc, _indexValue>;                           \
        GpuBenchmarkPropertyHolder::ShutdownFunc pShutdownFunc =                                                                                                \
            ShutdownEnumWrapper< std::remove_reference<decltype(*this)>::type, _enumType>;                                                                      \
        _propertyPtr->Initialize(&g_PropertyDefinition, pSetterGetterEnumContext, pGetterFunc, pSetterFunc, pShutdownFunc);                                     \
        _propertyPtr->Set(0);                                                                                                                                   \
    } while(false)
