﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once


#include "gfxUtilGpuBenchmark_GpuBenchmark.h"

#include "gfxUtilGpuBenchmark_Property.h"
#include "gfxUtilGpuBenchmark_PropertyArray.h"
#include "gfxUtilGpuBenchmark_ResShader.h"

#include <nn/gfx/gfx_Texture.h>
#include <nn/gfx/gfx_State.h>
#include <nn/gfx/gfx_DescriptorSlot.h>

//#define NN_GFXUTIL_GPUBENCHMARK_BLENDING_DEBUG

namespace nnt { namespace gfx { namespace util {

class GpuBenchmarkBlending : public GpuBenchmark
{
public:
    static const char*  ClassName;

private:
    static const int                    m_RenderSize = 2048;
    static const nn::gfx::TileMode      m_TileMode = nn::gfx::TileMode_Optimal;

    nn::gfx::ImageFormat                m_RenderFormat;

    nn::gfx::BlendFunction              m_BlendFunction;
    nn::gfx::BlendFactor                m_BlendDestinationFactor;
    nn::gfx::BlendFactor                m_BlendSourceFactor;

    nn::gfx::Texture                    m_RenderTexture;
    nn::gfx::ColorTargetView            m_RenderTextureColorTargetView;
    nn::gfx::ViewportScissorState       m_ViewportScissorState;

    nn::gfx::BlendState                 m_BlendState;

    ResShader                           m_ResShader;

    nn::gfx::Buffer                     m_VertexBuffer;

    nn::gfx::Buffer                     m_OutputCopyBuffer;
    size_t                              m_OutputCopyBufferSize;

#if defined(NN_GFXUTIL_GPUBENCHMARK_BLENDING_DEBUG)
    ResShader                           m_RenderQuadResShader;
    nn::gfx::TextureView                m_RenderTextureView;
    int                                 m_RenderTextureViewDescriptorSlotIndex;
    nn::gfx::DescriptorSlot             m_RenderTextureViewDescriptorSlot;

    nn::gfx::Sampler                    m_DebugTextureSampler;
    int                                 m_DebugTextureSamplerSlotIndex;
    nn::gfx::DescriptorSlot             m_DebugTextureSamplerDescriptorSlot;
#endif

    int                                 m_DrawIndex;



    enum Property
    {
        Property_RenderFormat,
        Property_BlendFunction,
        Property_BlendDestinationFactor,
        Property_BlendSourceFactor,
        Property_Count
    };

    PropertyArray<Property_Count>               m_PropertyArray;

public:
                                                GpuBenchmarkBlending();
    virtual                                     ~GpuBenchmarkBlending();

    virtual void                                Initialize(ResourceAllocator* pResourceAllocator) NN_OVERRIDE;
    virtual void                                Finalize(ResourceAllocator* pResourceAllocator) NN_OVERRIDE;

    virtual void                                InitializeGfxObjects(ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice) NN_OVERRIDE;
    virtual void                                FinalizeGfxObjects(ResourceAllocator* pResourceAllocator, nn::gfx::Device* pDevice) NN_OVERRIDE;

    nn::gfx::ImageFormat                        GetRenderFormat() const;
    void                                        SetRenderFormat(nn::gfx::ImageFormat format);

    nn::gfx::BlendFunction                      GetBlendFunction() const;
    void                                        SetBlendFunction(nn::gfx::BlendFunction function);

    nn::gfx::BlendFactor                        GetBlendDestinationFactor() const;
    void                                        SetBlendDestinationFactor(nn::gfx::BlendFactor factor);

    nn::gfx::BlendFactor                        GetBlendSourceFactor() const;
    void                                        SetBlendSourceFactor(nn::gfx::BlendFactor factor);

    virtual void                                PreBenchmark(nn::gfx::CommandBuffer* pTestCommandBuffer) NN_OVERRIDE;
    virtual void                                DoBenchmark(nn::gfx::CommandBuffer* pTestCommandBuffer, int runCount) NN_OVERRIDE;
    virtual void                                RenderDebug(nn::gfx::CommandBuffer* pTestCommandBuffer)  NN_OVERRIDE;

    virtual void                                PrintResults(nn::TimeSpan cpuTimeElapsed, nn::TimeSpan gpuTimeElapsed, int runCount, nn::gfx::util::DebugFontTextWriter* pDebugFontTextWriter) NN_OVERRIDE;

    virtual void                                CopyResultToBuffer(nn::gfx::CommandBuffer* pCommandBuffer) NN_OVERRIDE;
    virtual void                                MapResultBuffer(void** pOutBuffer, size_t* pOutBufferSize) NN_OVERRIDE;
    virtual void                                UnmapResultBuffer() NN_OVERRIDE;

    virtual const char*                         GetName() const NN_OVERRIDE;
    virtual BenchmarkType                       GetType() const NN_OVERRIDE;
    virtual int                                 GetPropertyCount() const NN_OVERRIDE;
    virtual int                                 FillPropertyList(const GpuBenchmarkPropertyHolder** ppDestinationArray, int destinationArrayMaxSize) const NN_OVERRIDE;
    virtual int                                 FillPropertyList(GpuBenchmarkPropertyHolder** ppDestinationArray, int destinationArrayMaxSize) NN_OVERRIDE;
    virtual GpuBenchmarkPropertyHolder*         FindPropertyByName(const char* propertyName) NN_OVERRIDE;
    virtual GpuBenchmarkPropertyHolder*         GetPropertyByIndex(int index) NN_OVERRIDE;
};

inline nn::gfx::ImageFormat GpuBenchmarkBlending::GetRenderFormat() const
{
    return m_RenderFormat;
}

inline void GpuBenchmarkBlending::SetRenderFormat(nn::gfx::ImageFormat format)
{
    m_RenderFormat = format;
}

inline nn::gfx::BlendFunction GpuBenchmarkBlending::GetBlendFunction() const
{
    return m_BlendFunction;
}

inline void GpuBenchmarkBlending::SetBlendFunction(nn::gfx::BlendFunction function)
{
    m_BlendFunction = function;
}

inline nn::gfx::BlendFactor GpuBenchmarkBlending::GetBlendDestinationFactor() const
{
    return m_BlendDestinationFactor;
}

inline void GpuBenchmarkBlending::SetBlendDestinationFactor(nn::gfx::BlendFactor factor)
{
    m_BlendDestinationFactor = factor;
}

inline nn::gfx::BlendFactor GpuBenchmarkBlending::GetBlendSourceFactor() const
{
    return m_BlendSourceFactor;
}

inline void GpuBenchmarkBlending::SetBlendSourceFactor(nn::gfx::BlendFactor factor)
{
    m_BlendSourceFactor = factor;
}

} } } // namespace nnt { namespace gfx { namespace util {
