﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

INOUT  Varying
{
#if BLIT_TEXTURE
    vec2 texCoord;
#else
    vec4 color;
#endif

} InOut;

#if VERTEX_SHADER

#if VS_USE_INSTANCING

in int gl_VertexID;

void main()
{
    float x = float(gl_VertexID & 0x01);
    float y = float((gl_VertexID & 0x02) >> 1);
    float scale = 1.0 / float((gl_VertexID >> 8) & 0xFF);
    float offsetX = float((gl_VertexID >> 16) & 0xFF);
    float offsetY = float((gl_VertexID >> 24) & 0xFF);

    float posX = (x + offsetX) * scale;
    float posY = (y + offsetY) * scale;

    float clipSpaceX = (posX * 2.0) - 1.0;
    float clipSpaceY = 1.0 - (posY * 2.0);

    vec4 position = vec4(clipSpaceX, clipSpaceY, 0.5, 1.0);
    vec2 texCoord = vec2(x, y);

    gl_Position = position;
#if BLIT_TEXTURE
    InOut.texCoord = texCoord;
#else
    InOut.color = texCoord.xyxy;
#endif
}

#else

layout(location = 0) in vec3 i_Position;
layout(location = 1) in vec2 i_TexCoord;

void main()
{
    gl_Position = vec4(i_Position, 1.0f);
#if BLIT_TEXTURE
    InOut.texCoord = i_TexCoord;
#else
    InOut.color = i_TexCoord.xyxy;
#endif
}

#endif // VS_USE_INSTANCING

#endif // VERTEX_SHADER

#if PIXEL_SHADER

layout(location = 0) out vec4 o_Color;

#if BLIT_TEXTURE
layout(binding = 0) uniform sampler2D tex;
#endif

void main()
{
#if BLIT_TEXTURE
    o_Color = texture(tex, InOut.texCoord);
#else
    o_Color = InOut.color;
#endif
}

#endif // PIXEL_SHADER
