﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

INOUT Varying
{
    vec4 position;
} InOut;



#if VERTEX_SHADER


in int gl_VertexID;

void main()
{
    float x = float(gl_VertexID & 0x01);
    float y = float((gl_VertexID & 0x02) >> 1);
    float clipSpaceX = (x * 2.0) - 1.0;
    float clipSpaceY = 1.0 - (y * 2.0);

    float polygonDepth  = (gl_VertexID >> 2) & 0x3FF;
    float maxDepth      = (gl_VertexID >> 12) & 0x3FF;
    float clipSpaceZ    = polygonDepth / maxDepth;

    vec4 position = vec4(clipSpaceX, clipSpaceY, clipSpaceZ, 1.0);

    gl_Position = position;
    InOut.position = position;
}


#endif

#if PIXEL_SHADER

layout(location = 0) out vec4 o_Color;


#if PS_ENABLE_DEPTH_WRITE
out float gl_FragDepth;
#endif

void main()
{
    o_Color = vec4(InOut.position.xy, 0.0, 1.0);
#if PS_ENABLE_DEPTH_WRITE
    gl_FragDepth = InOut.position.z;
#endif
}

#endif
