﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

 #pragma unroll all

INOUT Varying
{
    vec4 interp0;
    vec2 texCoord;
} InOut;


layout(std140, binding = 0) uniform ConstantBufferGridSize
{
    int instanceGridSize;
};

layout(std140, binding = 1) uniform ConstantBuffer
{
    vec4 transformMatrix[64][4];
};

#if VERTEX_SHADER



layout(location = 0) in vec4 i_Input0;
layout(location = 1) in vec4 i_Input1;
layout(location = 2) in vec4 i_Input2;
layout(location = 3) in vec4 i_Input3;
layout(location = 4) in vec4 i_Input4;
layout(location = 5) in vec4 i_Input5;
layout(location = 6) in vec4 i_Input6;
layout(location = 7) in vec4 i_Input7;

in int gl_VertexID;

void main()
{
    int gridSize    = instanceGridSize;
    int gridIndex   = gl_VertexID / 6;
    int vertexIndex = gl_VertexID % 6;

    int gridX       = gridIndex % gridSize;
    int gridY       = gridIndex / gridSize;

    float x         = float(gridX);
    float y         = float(gridY);
    float offsetX   = 0.0;
    float offsetY   = 0.0;

    if ((vertexIndex == 1) || (vertexIndex == 3) || (vertexIndex == 5))
        offsetX = 1.0;

    if ((vertexIndex == 2) || (vertexIndex == 4) || (vertexIndex == 5))
        offsetY = 1.0;

    float scale     = 1.0f / float(gridSize);
    float posX      = (x + offsetX) * scale;
    float posY      = (y + offsetY) * scale;

    float clipSpaceX = (posX * 2.0) - 1.0;
    float clipSpaceY = (posY * 2.0) - 1.0;

    vec4 position = vec4(clipSpaceX, clipSpaceY, 0.5, 1.0);

#if VS_TRANSFORM_COUNT > 0
    const int transformCount = VS_TRANSFORM_COUNT;
    for (int i = 0; i < transformCount; ++i)
    {
        vec4 tmp = position;
        position.x = dot(transformMatrix[i % 64][0], tmp);
        position.y = dot(transformMatrix[i % 64][1], tmp);
        position.z = dot(transformMatrix[i % 64][2], tmp);
        position.w = dot(transformMatrix[i % 64][3], tmp);
    }
#endif

    vec4 interp0 = position;

#if VS_ATTRIBUTE_COUNT > 0
    interp0 += i_Input0;
#endif
#if VS_ATTRIBUTE_COUNT > 1
    interp0 += i_Input1;
#endif
#if VS_ATTRIBUTE_COUNT > 2
    interp0 += i_Input2;
#endif
#if VS_ATTRIBUTE_COUNT > 3
    interp0 += i_Input3;
#endif
#if VS_ATTRIBUTE_COUNT > 4
    interp0 += i_Input4;
#endif
#if VS_ATTRIBUTE_COUNT > 5
    interp0 += i_Input5;
#endif
#if VS_ATTRIBUTE_COUNT > 6
    interp0 += i_Input6;
#endif
#if VS_ATTRIBUTE_COUNT > 7
    interp0 += i_Input7;
#endif

    gl_Position = position;
    InOut.interp0 = interp0;
    InOut.texCoord = vec2(posX, posY);
}

#endif

#if PIXEL_SHADER

layout(binding = 0) uniform sampler2D tex0;
layout(binding = 1) uniform sampler2D tex1;
layout(binding = 2) uniform sampler2D tex2;
layout(binding = 3) uniform sampler2D tex3;

layout(location = 0) out vec4 o_Color;

void main()
{
    vec4 result = InOut.interp0;

#if PS_TRANSFORM_COUNT > 0
    const int transformCount = PS_TRANSFORM_COUNT;
    for (int i = 0; i < transformCount; ++i)
    {
        vec4 tmp = result;
        result.x = dot(transformMatrix[i % 64][0], tmp);
        result.y = dot(transformMatrix[i % 64][1], tmp);
        result.z = dot(transformMatrix[i % 64][2], tmp);
        result.w = dot(transformMatrix[i % 64][3], tmp);
    }
#endif

#if PS_TEXTURE_COUNT > 0
    result += texture(tex0, InOut.texCoord);
#endif
#if PS_TEXTURE_COUNT > 1
    result += texture(tex1, InOut.texCoord);
#endif
#if PS_TEXTURE_COUNT > 2
    result += texture(tex2, InOut.texCoord);
#endif
#if PS_TEXTURE_COUNT > 3
    result += texture(tex3, InOut.texCoord);
#endif

    o_Color = result;
}

#endif
