﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/gfx/util/gfxUtil_AgingTestApi.h>

#include "gfxUtilAgingTest_LibraryState.h"

namespace nnt { namespace gfx { namespace util { namespace agingtest {

namespace
{

LibraryState g_State;

}

const Color DefaultColor::White     = { 255, 255, 255, 255 };
const Color DefaultColor::Gray      = { 127, 127, 127, 255 };
const Color DefaultColor::Black     = { 0, 0, 0, 255 };
const Color DefaultColor::Red       = { 255, 0, 0, 255 };
const Color DefaultColor::Green     = { 0, 255, 0, 255 };
const Color DefaultColor::Blue      = { 0, 0, 255, 255 };

void Initialize() NN_NOEXCEPT
{
    g_State.Initialize();
}

void Finalize() NN_NOEXCEPT
{
    g_State.Finalize();
}

nn::gfx::Device* GetGfxDevice() NN_NOEXCEPT
{
    return g_State.GetGfxDevice();
}

nn::gfx::CommandBuffer* GetCommandGfxBuffer() NN_NOEXCEPT
{
    return g_State.GetGfxCommandBuffer();
}


int GetFrameBufferWidth() NN_NOEXCEPT
{
    return g_State.GetFrameBufferWidth();
}

int GetFrameBufferHeight() NN_NOEXCEPT
{
    return g_State.GetFrameBufferHeight();
}

void GetTestPlatformId(char* buffer, int bufferSize) NN_NOEXCEPT
{
    return g_State.GetTestPlatformId(buffer, bufferSize);
}

nn::Result LoadTestSuiteFromFile(TestSuiteHandle* pHandle, const char* szFilePath) NN_NOEXCEPT
{
    return g_State.LoadTestSuiteFromFile(pHandle, szFilePath);
}

void UnloadTestSuite(TestSuiteHandle handle) NN_NOEXCEPT
{
    return g_State.UnloadTestSuite(handle);
}

int InitializeTestSuite(TestSuiteHandle handle, const char* filterPattern, int startIndex, int maxCount) NN_NOEXCEPT
{
    return g_State.InitializeTestSuite(handle, filterPattern, startIndex, maxCount);
}

void FinalizeTestSuite(TestSuiteHandle handle) NN_NOEXCEPT
{
    return g_State.FinalizeTestSuite(handle);
}

bool HasMoreTests(TestSuiteHandle handle) NN_NOEXCEPT
{
    return g_State.HasMoreTests(handle);
}

bool BeginNextTest(TestSuiteHandle handle) NN_NOEXCEPT
{
    return g_State.BeginNextTest(handle);
}

const char* GetTestName(TestSuiteHandle handle) NN_NOEXCEPT
{
    return g_State.GetTestName(handle);
}

const char* GetTestCaseId(TestSuiteHandle handle) NN_NOEXCEPT
{
    return g_State.GetTestCaseId(handle);
}

bool RunTest(int* pOutTestResultFlags, HashComparisonMode hashComparisonMode, TestSuiteHandle handle) NN_NOEXCEPT
{
    return g_State.RunTest(pOutTestResultFlags, hashComparisonMode, handle);
}

nn::Result LoadTextureResourceFromFile(const char* szFilePath, TextureHandle* pOutHandle)  NN_NOEXCEPT
{
    return CreateTextureFromResourceFile(pOutHandle, szFilePath);
}

nn::Result CreateTextureFromResourceFile(TextureHandle* pOutHandle, const char* szFilePath) NN_NOEXCEPT
{
    return g_State.CreateTextureFromResourceFile(pOutHandle, szFilePath);
}

nn::Result CreateTextureFromBmpBuffer(TextureHandle* pOutHandle, const void* bmpBuffer, size_t bmpBufferSizeInBytes) NN_NOEXCEPT
{
    return g_State.CreateTextureFromBmpBuffer(pOutHandle, bmpBuffer, bmpBufferSizeInBytes);
}

nn::Result CreateTextureFromBmpFile(TextureHandle* pOutHandle, const char* szFilePath) NN_NOEXCEPT
{
    return g_State.CreateTextureFromBmpFile(pOutHandle, szFilePath);
}

nn::Result CreateTextureFromPixelBuffer(
    TextureHandle* pOutHandle, const void* pPixelBuffer, size_t pixelBufferSizeInBytes,
    int width, int height, int pitch, PixelFormat pixelFormat) NN_NOEXCEPT
{
    return g_State.CreateTextureFromPixelBuffer(
        pOutHandle, pPixelBuffer, pixelBufferSizeInBytes,
        width, height, pitch, pixelFormat);
}

void FreeTextureResource(TextureHandle handle) NN_NOEXCEPT
{
    g_State.FreeTextureResource(handle);
}

int GetTextureWidth(TextureHandle handle) NN_NOEXCEPT
{
    return g_State.GetTextureWidth(handle);
}

int GetTextureHeight(TextureHandle handle) NN_NOEXCEPT
{
    return g_State.GetTextureHeight(handle);
}

void StartFrame() NN_NOEXCEPT
{
    g_State.StartFrame();
}

void EndFrame() NN_NOEXCEPT
{
    g_State.EndFrame();
}

void DrawTestResults(TestSuiteHandle handle, int positionX, int positionY, float scale, const Color& color) NN_NOEXCEPT
{
    g_State.DrawTestResults(handle, positionX, positionY, scale, color);
}

void DrawFont(const char* text, int positionX, int positionY, float scale, const Color& color) NN_NOEXCEPT
{
    g_State.DrawFont(text, positionX, positionY, scale, color);
}

void Draw2DFrame(int positionX, int positionY, int width, int height, const Color& color) NN_NOEXCEPT
{
    g_State.Draw2DFrame(positionX, positionY, width, height, color);
}

void Draw2DRect(int positionX, int positionY, int width, int height, const Color& color) NN_NOEXCEPT
{
    g_State.Draw2DRect(positionX, positionY, width, height, color);
}

void Draw2DRectTexture(int positionX, int positionY, int width, int height, TextureHandle handle) NN_NOEXCEPT
{
    g_State.Draw2DRectTexture(positionX, positionY, width, height, handle);
}

void DrawTestDebugInformation(TestSuiteHandle handle) NN_NOEXCEPT
{
    g_State.DrawTestDebugInformation(handle);
}

nn::gfx::CommandBuffer* GetCommandBuffer() NN_NOEXCEPT
{
    return g_State.GetGfxCommandBuffer();
}

nns::gfx::PrimitiveRenderer::Renderer* GetPrimitiveRenderer() NN_NOEXCEPT
{
    return g_State.GetPrimitiveRenderer();
}

void GetFps(float* pOutMinFps, float *pOutMaxFps, float* pOutAverageFps) NN_NOEXCEPT
{
    g_State.GetFps(pOutMinFps, pOutMaxFps, pOutAverageFps);
}

} } } } // namespace nnt { namespace gfx { namespace util { namespace agingtest {
