﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testGfx_TextureCapture.h"
#include <nnt/graphics/testGraphics_AllocatorFunction.h>

namespace nnt{ namespace gfx{

    class ColorTargetViewCapture
    {
    public:
        ColorTargetViewCapture();
        ~ColorTargetViewCapture();
        void Initialize(
            ptrdiff_t* pOutNewMemoryPoolOffset,
            ptrdiff_t* pOutNewInvisibleMemoryPoolOffset,
            nn::gfx::Device* pDevice,
            nn::gfx::MemoryPool* pMemoryPool,
            nn::gfx::MemoryPool* pInvisibleMemoryPool,
            ptrdiff_t currentMemoryPoolOffset,
            ptrdiff_t currentInvisibleMemoryPoolOffset,
            nnt::graphics::AllocatorFunction* pAllocatorFunction,
            int screenWidth,
            int screenHeight);
        void Finalize();

        /**
         * @brief キャプチャを実行中かを返します。
         *
         * @details PushCaptureCommand() の呼び出しにより、 true を返すようになります。
         *   FetchCaptureResult() の呼び出しにより、 false を返すようになります。
         */
        bool IsCapturing() const;

        /**
         * @brief 画面のキャプチャを行うコマンドを挿入します。
         */
        void PushCaptureCommand(nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::ColorTargetView* pSrcView);
        /**
         * @brief キャプチャした画面を内部バッファに転送します。
         */
        void FetchCaptureResult();

        /**
         * @brief 最後にキャプチャした画像データを取得します。
         */
        const uint8_t* GetCapturedImageData() const;
        /**
         * @brief 最後にキャプチャした画像データの容量を取得します。
         */
        size_t GetCapturedImageDataSize() const;

    private:
        bool m_IsInitialized;

        TextureCapture m_TextureCapture;

        nn::gfx::Device* m_pDevice;
        nn::gfx::Texture m_Texture;
    };

}}
