﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/////////////////////////////////////////////////////////////////////////////
//
// format.h
//
//////////////////////////////////////////////////////////////////////////////

#pragma once

#include <cstdio>
#include <cstring>

#include <gfx/demo.h>

#ifdef __cplusplus
extern "C" {
#endif

static const int NUM_ATTRIBUTE = 55;

typedef struct _VtxFmtU8x1 {
    u8 color;
} VtxFmtU8x1;

typedef struct _VtxFmtU16x1 {
    u16 color;
} VtxFmtU16x1;

typedef struct _VtxFmtU8x2 {
    u8 color[2];
} VtxFmtU8x2;

typedef struct _VtxFmtU32x1 {
    u32 color;
} VtxFmtU32x1;

typedef struct _VtxFmtF32x1 {
    f32 color;
} VtxFmtF32x1;

typedef struct _VtxFmtU16x2 {
    u16 color[2];
} VtxFmtU16x2;

typedef struct _VtxFmtU8x4 {
    u8 color[4];
} VtxFmtU8x4;

typedef struct _VtxFmtU32x2 {
    u32 color[2];
} VtxFmtU32x2;

typedef struct _VtxFmtF32x2 {
    f32 color[2];
} VtxFmtF32x2;

typedef struct _VtxFmtU16x4 {
    u16 color[4];
} VtxFmtU16x4;

typedef struct _VtxFmtU32x3 {
    u32 color[3];
} VtxFmtU32x3;

typedef struct _VtxFmtF32x3 {
    f32 color[3];
} VtxFmtF32x3;

typedef struct _VtxFmtU32x4 {
    u32 color[4];
} VtxFmtU32x4;

typedef struct _VtxFmtF32x4 {
    f32 color[4];
} VtxFmtF32x4;

//
// Functions and declarations related to converting a floating point
// clear color to different surface formats.
//
typedef struct _NBitFloatDesc
{
    u32  bitSize;     ///< total number of bits in the representation - N
    u32  numFracBits; ///< number of fractional (mantissa) bits
    u32  numExpBits;  ///< number of (biased) exponent bits
    u32  signBit;     ///< position of the sign bit, zero if fN is unsigned
    u32  signMask;    ///< mask to extract sign bit, zero if fN is unsigned
    u32  fracMask;    ///< mask to extract the fractional (mantissa) bits
    u32  expMask;     ///< mask to extract the exponent bits
    s32  expBias;     ///< bias for the exponent
    u32  eMax;        ///< max value for the exponent
    s32  eMin;        ///< min value for the exponent
    u32  maxNormal;   ///< max value that can be represented by the Nbit float
    u32  minNormal;   ///< min value that can be represented by the Nbit float
    u32  biasDiff;    ///< difference in bias between the fN and f32 exponent
    u32  fracBitsDiff; ///< difference in number of fractional bits between fN/f32
} NBitFloatDesc;

#ifdef __cplusplus
}
#endif
