﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/gfx.h>

namespace {

template< typename TSource, typename TDestination >
TDestination Convert( TSource source, typename std::remove_pointer<
    typename std::remove_reference< TSource >::type >::type::DataType* )
{
    return nn::gfx::AccessorToData( source );
}
template< typename TSource, typename TDestination >
TDestination Convert( TSource source, ... )
{
    return nn::gfx::DataToAccessor( source );
}

template< typename T >
struct ToPtr;
template< typename T >
struct ToPtr< T& >
{
    static T* Get( T& value )
    {
        return &value;
    }
};
template< typename T >
struct ToPtr< T* >
{
    static T* Get( T* value )
    {
        return value;
    }
};

template< typename TSource, typename TDestination >
void DataAccessorConversionTest()
{
    typedef typename std::remove_cv< typename std::remove_pointer<
        typename std::remove_reference< TSource >::type >::type >::type SourceType;
    SourceType original;
    TSource source = nn::gfx::detail::Caster< SourceType >( &original );
    TDestination destination = Convert< TSource, TDestination >( source, 0 );
    const void* pDestination = ToPtr< TDestination >::Get( destination );
    EXPECT_EQ( static_cast< const void* >( &original ), pDestination );
}

}

template< typename T >
class DataAccessorTest
    : public testing::Test
{
};

typedef ::testing::Types<
    nn::gfx::Buffer
    , nn::gfx::CommandBuffer
    , nn::gfx::DescriptorPool
    , nn::gfx::Device
    , nn::gfx::MemoryPool
    , nn::gfx::Queue
    , nn::gfx::Sampler
    , nn::gfx::Shader
    , nn::gfx::RasterizerState
    , nn::gfx::BlendState
    , nn::gfx::DepthStencilState
    , nn::gfx::VertexState
    , nn::gfx::TessellationState
    , nn::gfx::ViewportScissorState
    , nn::gfx::SwapChain
    , nn::gfx::Fence
    , nn::gfx::Semaphore
    , nn::gfx::Texture
    , nn::gfx::TextureView
    , nn::gfx::ColorTargetView
    , nn::gfx::DepthStencilView
    , nn::gfx::GpuAddress
    , nn::gfx::DescriptorSlot
    , nn::gfx::BufferInfo
    , nn::gfx::CommandBufferInfo
    , nn::gfx::DescriptorPoolInfo
    , nn::gfx::DeviceInfo
    , nn::gfx::MemoryPoolInfo
    , nn::gfx::QueueInfo
    , nn::gfx::SamplerInfo
    , nn::gfx::ShaderInfo
    , nn::gfx::MultisampleStateInfo
    , nn::gfx::RasterizerStateInfo
    , nn::gfx::BlendTargetStateInfo
    , nn::gfx::BlendStateInfo
    , nn::gfx::StencilStateInfo
    , nn::gfx::DepthStencilStateInfo
    , nn::gfx::ColorTargetStateInfo
    , nn::gfx::RenderTargetStateInfo
    , nn::gfx::VertexAttributeStateInfo
    , nn::gfx::VertexBufferStateInfo
    , nn::gfx::VertexStateInfo
    , nn::gfx::TessellationStateInfo
    , nn::gfx::ViewportStateInfo
    , nn::gfx::ScissorStateInfo
    , nn::gfx::ViewportScissorStateInfo
    , nn::gfx::SwapChainInfo
    , nn::gfx::FenceInfo
    , nn::gfx::SemaphoreInfo
    , nn::gfx::TextureInfo
    // 50 個まで
    //, nn::gfx::TextureViewInfo
    //, nn::gfx::ColorTargetStateInfo
    //, nn::gfx::DepthStencilViewInfo
    //, nn::gfx::TextureMipRange
    //, nn::gfx::TextureArrayRange
    //, nn::gfx::TextureSubresourceRange
    //, nn::gfx::TextureSubresource
    //, nn::gfx::TextureCopyRegion
    //, nn::gfx::BufferTextureCopyRegion
     >
    DataAccessorTestTypes;

TYPED_TEST_CASE( DataAccessorTest, DataAccessorTestTypes );

TYPED_TEST( DataAccessorTest, DataToAccessor )
{
    typedef TypeParam AccessorType;
    typedef typename AccessorType::DataType DataType;

    DataAccessorConversionTest< DataType&, AccessorType& >();
    DataAccessorConversionTest< DataType&, const AccessorType& >();
    DataAccessorConversionTest< const DataType&, const AccessorType& >();

    DataAccessorConversionTest< DataType&, AccessorType* >();
    DataAccessorConversionTest< DataType&, const AccessorType* >();
    DataAccessorConversionTest< const DataType&, const AccessorType* >();

    DataAccessorConversionTest< DataType*, AccessorType& >();
    DataAccessorConversionTest< DataType*, const AccessorType& >();
    DataAccessorConversionTest< const DataType*, const AccessorType& >();

    DataAccessorConversionTest< DataType*, AccessorType* >();
    DataAccessorConversionTest< DataType*, const AccessorType* >();
    DataAccessorConversionTest< const DataType*, const AccessorType* >();
}

TYPED_TEST( DataAccessorTest, AccessorToData )
{
    typedef TypeParam AccessorType;
    typedef typename AccessorType::DataType DataType;

    DataAccessorConversionTest< AccessorType&, DataType& >();
    DataAccessorConversionTest< AccessorType&, const DataType& >();
    DataAccessorConversionTest< const AccessorType&, const DataType& >();

    DataAccessorConversionTest< AccessorType&, DataType* >();
    DataAccessorConversionTest< AccessorType&, const DataType* >();
    DataAccessorConversionTest< const AccessorType&, const DataType* >();

    DataAccessorConversionTest< AccessorType*, DataType& >();
    DataAccessorConversionTest< AccessorType*, const DataType& >();
    DataAccessorConversionTest< const AccessorType*, const DataType& >();

    DataAccessorConversionTest< AccessorType*, DataType* >();
    DataAccessorConversionTest< AccessorType*, const DataType* >();
    DataAccessorConversionTest< const AccessorType*, const DataType* >();
}
