﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/// @addtogroup demoGfxTypes
/// @{

//
// Data Types
//

/// \brief Struct contains floatx4
///
typedef struct _DEMO_F32x4
{
    union
    {
        struct{ f32 x, y, z, w;} v;
        struct{ f32 r, g, b, a;} c;
        f32 F32[4];
    } u;
} DEMO_F32x4;

/// \brief Struct contains floatx3
///
typedef struct _DEMO_F32x3
{
    union
    {
        struct{ f32 x, y, z;} v;
        struct{ f32 r, g, b;} c;
        f32 F32[3];
    } u;
} DEMO_F32x3;

/// \brief Struct contains floatx2
///
typedef struct _DEMO_F32x2
{
    union
    {
        struct{ f32 x, y;} v;
        struct{ f32 r, g;} c;
        f32 F32[2];
    } u;
} DEMO_F32x2;

/// \brief Struct contains float
///
typedef struct _DEMO_F32
{
    union
    {
        struct{ f32 x;} v;
        struct{ f32 r;} c;
        f32 F32;
    } u;
} DEMO_F32;

/// \brief Struct contains U32x4
///
typedef struct _DEMO_U32x4
{
    union
    {
        struct{ u32 x, y, z, w;} v;
        struct{ u32 r, g, b, a;} c;
        u32 U32[4];
    } u;
} DEMO_U32x4;

/// \brief Struct contains U32x3
///
typedef struct _DEMO_U32x3
{
    union
    {
        struct{ u32 x, y, z;} v;
        struct{ u32 r, g, b;} c;
        u32 U32[3];
    } u;
} DEMO_U32x3;

/// \brief Struct contains U32x2
///
typedef struct _DEMO_U32x2
{
    union
    {
        struct{ u32 x, y;} v;
        struct{ u32 r, g;} c;
        u32 U32[2];
    } u;
} DEMO_U32x2;

/// \brief Struct contains U32
///
typedef struct _DEMO_U32
{
    union
    {
        struct{ u32 x;} v;
        struct{ u32 r;} c;
        u32 U32;
    } u;
} DEMO_U32;

/// \brief Struct contains S32x4
///
typedef struct _DEMO_S32x4
{
    union
    {
        struct{ s32 x, y, z, w;} v;
        struct{ s32 r, g, b, a;} c;
        s32 S32[4];
    } u;
} DEMO_S32x4;

/// \brief Struct contains S32x3
///
typedef struct _DEMO_S32x3
{
    union
    {
        struct{ s32 x, y, z;} v;
        struct{ s32 r, g, b;} c;
        s32 S32[3];
    } u;
} DEMO_S32x3;

/// \brief Struct contains S32x2
///
typedef struct _DEMO_S32x2
{
    union
    {
        struct{ s32 x, y;} v;
        struct{ s32 r, g;} c;
        s32 S32[2];
    } u;
} DEMO_S32x2;

/// \brief Struct contains S32
///
typedef struct _DEMO_S32
{
    union
    {
        struct{ s32 x;} v;
        struct{ s32 r;} c;
        s32 S32;
    } u;
} DEMO_S32;

/// \brief Struct contains U16x4
///
typedef struct _DEMO_U16x4
{
    union
    {
        struct{ u16 x, y, z, w;} v;
        struct{ u16 r, g, b, a;} c;
        u16 U16[4];
    } u;
} DEMO_U16x4;

/// \brief Struct contains U16x3
///
typedef struct _DEMO_U16x3
{
    union
    {
        struct{ u16 x, y, z;} v;
        struct{ u16 r, g, b;} c;
        u16 U16[3];
    } u;
} DEMO_U16x3;

/// \brief Struct contains U16x2
///
typedef struct _DEMO_U16x2
{
    union
    {
        struct{ u16 x, y;} v;
        struct{ u16 r, g;} c;
        u16 U16[2];
    } u;
} DEMO_U16x2;

/// \brief Struct contains U16
///
typedef struct _DEMO_U16
{
    union
    {
        struct{ u16 x;} v;
        struct{ u16 r;} c;
        u16 U16;
    } u;
} DEMO_U16;

/// \brief Struct contains S16x4
///
typedef struct _DEMO_S16x4
{
    union
    {
        struct{ s16 x, y, z, w;} v;
        struct{ s16 r, g, b, a;} c;
        s16 S16[4];
    } u;
} DEMO_S16x4;

/// \brief Struct contains S16x3
///
typedef struct _DEMO_S16x3
{
    union
    {
        struct{ s16 x, y, z;} v;
        struct{ s16 r, g, b;} c;
        s16 S16[3];
    } u;
} DEMO_S16x3;

/// \brief Struct contains S16x2
///
typedef struct _DEMO_S16x2
{
    union
    {
        struct{ s16 x, y;} v;
        struct{ s16 r, g;} c;
        s16 S16[2];
    } u;
} DEMO_S16x2;

/// \brief Struct contains S16
///
typedef struct _DEMO_S16
{
    union
    {
        struct{ s16 x;} v;
        struct{ s16 r;} c;
        s16 S16;
    } u;
} DEMO_S16;

/// \brief Struct contains U8x4
///
typedef struct _DEMO_U8x4
{
    union
    {
        struct{ u8 x, y, z, w;} v;
        struct{ u8 r, g, b, a;} c;
        u8 U8[4];
    } u;
} DEMO_U8x4;

/// \brief Struct contains U8x3
///
typedef struct _DEMO_U8x3
{
    union
    {
        struct{ u8 x, y, z;} v;
        struct{ u8 r, g, b;} c;
        u8 U8[3];
    } u;
} DEMO_U8x3;

/// \brief Struct contains U8x2
///
typedef struct _DEMO_U8x2
{
    union
    {
        struct{ u8 x, y;} v;
        struct{ u8 r, g;} c;
        u8 U8[2];
    } u;
} DEMO_U8x2;

/// \brief Struct contains U8
///
typedef struct _DEMO_U8
{
    union
    {
        struct{ u8 x;} v;
        struct{ u8 r;} c;
        u8 U8;
    } u;
} DEMO_U8;

/// \brief Struct contains S8x4
///
typedef struct _DEMO_S8x4
{
    union
    {
        struct{ s8 x, y, z, w;} v;
        struct{ s8 r, g, b, a;} c;
        s8 S8[4];
    } u;
} DEMO_S8x4;

/// \brief Struct contains S8x3
///
typedef struct _DEMO_S8x3
{
    union
    {
        struct{ s8 x, y, z;} v;
        struct{ s8 r, g, b;} c;
        s8 S8[3];
    } u;
} DEMO_S8x3;

/// \brief Struct contains S8x2
///
typedef struct _DEMO_S8x2
{
    union
    {
        struct{ s8 x, y;} v;
        struct{ s8 r, g;} c;
        s8 S8[2];
    } u;
} DEMO_S8x2;

/// \brief Struct contains S8
///
typedef struct _DEMO_S8
{
    union
    {
        struct{ s8 x;} v;
        struct{ s8 r;} c;
        s8 S8;
    } u;
} DEMO_S8;


//
// Helper types for attributes
//

/// \brief Struct contains f32x4x4
///
typedef struct _DEMO_F32x4F32x4F32x4F32x4
{
    DEMO_F32x4 F32x4[4];
} DEMO_F32x4F32x4F32x4F32x4;

/// \brief Struct contains f32x4x3
///
typedef struct _DEMO_F32x4F32x4F32x4
{
    DEMO_F32x4 F32x4[3];
} DEMO_F32x4F32x4F32x4;

/// \brief Struct contains f32x4x2
///
typedef struct _DEMO_F32x4F32x4
{
    DEMO_F32x4 F32x4[2];
} DEMO_F32x4F32x4;

/// \brief Struct contains f32x3x3
///
typedef struct _DEMO_F32x3F32x3F32x3
{
    DEMO_F32x3 F32x3[3];
} DEMO_F32x3F32x3F32x3;

/// \brief Struct contains f32x3x2
///
typedef struct _DEMO_F32x3F32x3
{
    DEMO_F32x3 F32x3[2];
} DEMO_F32x3F32x3;

/// \brief Struct contains f32x3f32x2
///
typedef struct _DEMO_F32x3F32x2
{
    DEMO_F32x3 F32x3;
    DEMO_F32x2 F32x2;
} DEMO_F32x3F32x2;


/// \brief Struct contains f32x4f32x3
///
typedef struct _DEMO_F32x4F32x3
{
    DEMO_F32x4 F32x4;
    DEMO_F32x3 F32x3;
} DEMO_F32x4F32x3;

/// \brief Struct contains f32x3f32x4
///
typedef struct _DEMO_F32x3F32x4
{
    DEMO_F32x3 F32x3;
    DEMO_F32x4 F32x4;
} DEMO_F32x3F32x4;

/// \brief Struct contains f32x3f32x4x2
///
typedef struct _DEMO_F32x3F32x4F32x4
{
    DEMO_F32x3 F32x3;
    DEMO_F32x4 F32x4[2];
} DEMO_F32x3F32x4F32x4;


/// \brief Struct contains f32x4x2f32x3
///
typedef struct _DEMO_F32x4F32x4F32x3
{
    DEMO_F32x4 F32x4[2];
    DEMO_F32x3 F32x3;
} DEMO_F32x4F32x4F32x3;

/// \brief Struct contains f32x4x3f32x2
///
typedef struct _DEMO_F32x4F32x4F32x4F32x2
{
    DEMO_F32x4 F32x4[3];
    DEMO_F32x2 F32x2;
} DEMO_F32x4F32x4F32x4F32x2;

/// \brief Struct contains f32x4f32x3x2
///
typedef struct _DEMO_F32x4F32x3F32x3
{
    DEMO_F32x4 F32x4;
    DEMO_F32x3 F32x3[2];
} DEMO_F32x4F32x3F32x3;

/// \brief Struct contains f32x4f32x3x2f32x2
///
typedef struct _DEMO_F32x4F32x4F32x3F32x2
{
    DEMO_F32x4 F32x4[2];
    DEMO_F32x3 F32x3;
    DEMO_F32x2 F32x2;
} DEMO_F32x4F32x4F32x3F32x2;


/// \brief Struct contains f32x4f32x3x2f32x2
///
typedef struct _DEMO_F32x4F32x3F32x3F32x2
{
    DEMO_F32x4 F32x4;
    DEMO_F32x3 F32x3[2];
    DEMO_F32x2 F32x2;
} DEMO_F32x4F32x3F32x3F32x2;

/// \brief Struct contains f32x4f32x3f32x2
///
typedef struct _DEMO_F32x4F32x3F32x2
{
    DEMO_F32x4 F32x4;
    DEMO_F32x3 F32x3;
    DEMO_F32x2 F32x2;
} DEMO_F32x4F32x3F32x2;

/// \brief Struct contains f32x3f32x3f32x2
///
typedef struct _DEMO_F32x3F32x3F32x2
{
    DEMO_F32x3 F32x3[2];
    DEMO_F32x2 F32x2;
} DEMO_F32x3F32x3F32x2;

/// \brief Struct contains f32x3f32x3f32x3f32x3f32x2
///
typedef struct _DEMO_F32x3F32x3F32x3F32x3F32x2
{
    DEMO_F32x3 F32x3[4];
    DEMO_F32x2 F32x2;
} DEMO_F32x3F32x3F32x3F32x3F32x2;


/// @}
