﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// -----------------------------------------------------------------------------
//  demoDRCCamera.h
//
// -----------------------------------------------------------------------------

#pragma once

#include <gfx/demo.h>

/// @addtogroup demoDRCCamera
/// @{

/// \brief Default surface for DEMODRCCamera (global)
extern CAMSurface       DEMODRCCameraSurface[2];

/// \brief Default Y texture for DEMODRCCamera (global)
extern GX2Texture          DEMODRCCameraYTexture;

/// \brief Default UV texture for DEMODRCCamera (global)
extern GX2Texture          DEMODRCCameraUVTexture;

/// \brief Default camera setup information for DEMODRCCamera (global)
extern CAMSetupInfo     DEMODRCCameraSetupInfo;

/// \brief Default camera handle for DEMODRCCamera (global)
extern CAMHandle        DEMOCameraHandle;

/// \brief Set up drc camera.
///
void DEMODRCCameraInit(DRC_CAMERA_FPS fps);

/// \brief Release drc camera
///
void DEMODRCCameraShutdown(void);

/// \brief Open drc camera.
///
void DEMODRCCameraOpen(void);

/// \brief Close drc camera
///
void DEMODRCCameraClose(void);

/// \brief Safely allocate memory for camera usage
///
void* DEMODRCCameraMemAlloc(int size, int alignment);


/// @}  // demoDRCCamera
