﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/nn_Assert.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/gfx.h>
#include <nn/g3d.h>

#include "nnt/g3d/testG3d_TestUtility.h"

nn::gfx::Device* GetDevice() NN_NOEXCEPT;
nn::g3d::ResFile* GetResFile() NN_NOEXCEPT;
nn::g3d::ResShaderFile* GetResShaderFile(int index = 0) NN_NOEXCEPT;
nn::lmem::HeapHandle& GetMemoryHandle() NN_NOEXCEPT;
size_t GetFileAlignment(const char* path) NN_NOEXCEPT;

bool IsFloatEqual(float value1, float value2, int significantDigits = 5) NN_NOEXCEPT;
bool IsFloatArrayEqual(const float* valueArray1, const float* valueArray2, int arraySize, int significantDigits = 5) NN_NOEXCEPT;
bool IsVector3fEqual(const nn::util::Vector3fType& vector1, const nn::util::Vector3fType& vector2, int significantDigits = 5) NN_NOEXCEPT;
bool IsMtx43Equal(const nn::util::Matrix4x3fType& mtx1, const nn::util::Matrix4x3fType& mtx2, int significantDigits = 5) NN_NOEXCEPT;
bool IsMtx44Equal(const nn::util::Matrix4x4fType& mtx1, const nn::util::Matrix4x4fType& mtx2, int significantDigits = 5) NN_NOEXCEPT;

ptrdiff_t AllocateMemoryPool(size_t size, size_t alignment) NN_NOEXCEPT;
void FreeMemoryPool() NN_NOEXCEPT;
size_t GetWriteCombineMemoryPoolAllocatableSize() NN_NOEXCEPT;
nn::gfx::MemoryPool* GetWriteCombineMemoryPool() NN_NOEXCEPT;

class SimplePtr
{
public:
    explicit SimplePtr(void* ptr) NN_NOEXCEPT
        : m_Ptr(ptr)
    {
        EXPECT_TRUE(m_Ptr != NULL);
    }

    ~SimplePtr() NN_NOEXCEPT
    {
        nnt::g3d::Deallocate(m_Ptr);
    }

    void* Get() NN_NOEXCEPT
    {
        return m_Ptr;
    }

private:
    void* m_Ptr;
};

class G3dTest : public ::testing::Test {
protected:
    virtual void SetUp() NN_NOEXCEPT
    {
    }
    virtual void TearDown() NN_NOEXCEPT
    {
    }
};
