﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testG3d_Main.h"
#include "nnt/g3d/testG3d_TestUtility.h"

#if defined(NN_BUILD_CONFIG_SPEC_GENERIC)

const char* g_3dSampleViewerShaderPath[] =
{
    "Resource:/3dSampleViewerResources/demo.bfsha",
    "Resource:/3dSampleViewerResources/town.bfsha",
};
const int G3dSampleViewerShaderFileCount = sizeof(g_3dSampleViewerShaderPath) / sizeof(char*);
const char* g_3dSampleViewerModelPath = "Resource:/3dSampleViewerResources/town_env.bfres";
const char* g_3dSampleViewerTexturePath = "Resource:/3dSampleViewerResources/Shared.bntx";

TEST_F(G3dTest, VersionOf3dSampleViewerModelResources)
{
    size_t alignment = GetFileAlignment(g_3dSampleViewerModelPath);
    size_t size;
    void* pFile = nnt::g3d::LoadFile(&size, g_3dSampleViewerModelPath, alignment);
    EXPECT_TRUE(nn::g3d::ResFile::IsValid(pFile));
    nnt::g3d::UnloadFile(pFile);
}

TEST_F(G3dTest, VersionOf3dSampleViewerShaderResources)
{
    for (int i = 0; i < G3dSampleViewerShaderFileCount; ++i)
    {
        size_t alignment = GetFileAlignment(g_3dSampleViewerModelPath);
        size_t size;
        void* pFile = nnt::g3d::LoadFile(&size, g_3dSampleViewerShaderPath[i], alignment);
        EXPECT_TRUE(nn::g3d::ResShaderFile::IsValid(pFile));
        nnt::g3d::UnloadFile(pFile);
    }
}

TEST_F(G3dTest, VersionOf3dSampleViewerTextureResources)
{
    size_t alignment = GetFileAlignment(g_3dSampleViewerModelPath);
    size_t size;
    void* pFile = nnt::g3d::LoadFile(&size, g_3dSampleViewerTexturePath, alignment);
    nn::gfx::ResTextureFile* pCastedFile = static_cast<nn::gfx::ResTextureFile*>(pFile);
    EXPECT_TRUE(pCastedFile->GetBinaryFileHeader()->IsValid(
        nn::gfx::ResTextureFile::Signature,
        nn::gfx::ResTextureFile::MajorVersion,
        nn::gfx::ResTextureFile::MinorVersion,
        nn::gfx::ResTextureFile::MicroVersion));
    nnt::g3d::UnloadFile(pFile);
}

#endif
