﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <nn/mii.h>

template <typename TType1, typename TType2> struct MiiBindTable
{
    nn::util::string_view    name;
    TType1    type1;
    TType2    type2;
};

typedef MiiBindTable<nn::mii::CharModel::DrawType, int> MaterialNameDrawTypeTable;
typedef MiiBindTable<nn::mii::CreateModelType, nn::mii::CreateNoseType> BoneNameCreateModelTypeNoseType;

template<typename TType1, typename TType2, size_t TTableSize>
int FindMiiBindTableIndex( const char* pTargetName, const MiiBindTable<TType1, TType2>( &miiBindTableArray )[TTableSize] )
{
    for( int idxTbl = 0; idxTbl  < static_cast<int>( TTableSize ); ++idxTbl  )
    {
        auto& miiBindTable = miiBindTableArray[idxTbl];
        if( miiBindTable.name == pTargetName )
        {
            return idxTbl;
        }
    }
    return -1;
};
template<typename TType1, typename TType2>
int FindMiiBindTableIndex( const char* pTargetName, const MiiBindTable<TType1, TType2>* miiBindTableArray, size_t miiBindTableArraySize )
{
    for( int idxTbl = 0; idxTbl  < static_cast<int>( miiBindTableArraySize ); ++idxTbl  )
    {
        auto& miiBindTable = miiBindTableArray[idxTbl];
        if( miiBindTable.name == pTargetName )
        {
            return idxTbl;
        }
    }
    return -1;
};
