﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <nn/gfx.h>
#include <nn/mii.h>

namespace nn { namespace g3d {
    class ResFile;
}}
class CharModelCreateArg;

//!< nn::mii::CharModel を初期化するための情報を保持するクラスです。
class MiiCharModel
{
public:
    MiiCharModel()
    {
    }

    ~MiiCharModel()
    {
    }

    void Initialize( nn::gfx::Device* pDevice, const CharModelCreateArg* pCharModelCreateArg );
    void Finalize( nn::gfx::Device* pDevice );

    const nn::mii::CharModel* GetCharModel() const
    {
        return &m_CharModel;
    }

private:
    nn::mii::Resource        m_Resource;
    nn::mii::CharInfo*       m_pCharInfo;
    void*                    m_pTextureResourceFile;
    void*                    m_pShapeResourceFile;

    nn::mii::CharModel       m_CharModel;
    nn::gfx::MemoryPool      m_CharModelMemPool;
};
