﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nn/nn_Assert.h>
#include <nn/gfx.h>
#include <nn/g3d.h>

bool IsFloatEqual(float value1, float value2, int significantDigits = 5) NN_NOEXCEPT;
bool IsVector3fEqual(const nn::util::Vector3fType& vector1, const nn::util::Vector3fType& vector2, int significantDigits = 5) NN_NOEXCEPT;
bool IsVector4fEqual(const nn::util::Vector4fType& vector1, const nn::util::Vector4fType& vector2, int significantDigits = 5) NN_NOEXCEPT;
bool IsMtx43Equal(const nn::util::Matrix4x3fType& mtx1, const nn::util::Matrix4x3fType& mtx2, int significantDigits = 5) NN_NOEXCEPT;
bool IsMtx44Equal(const nn::util::Matrix4x4fType& mtx1, const nn::util::Matrix4x4fType& mtx2, int significantDigits = 5) NN_NOEXCEPT;

class G3dTest : public ::testing::Test {
protected:
    virtual void SetUp() NN_NOEXCEPT
    {
    }
    virtual void TearDown() NN_NOEXCEPT
    {
    }
};

void CheckResFileDataEqual(const nn::g3d::ResFileData& data, const nn::g3d::ResFileData& referenceData) NN_NOEXCEPT;
