@echo off
set PROJFILE=
set PLATFORM=
set CONFIGURATION=
set VS_VERSION=VS2013
set SPEC=%1
set OS=%2
set ADDRESS=%3
set BUILD_TARGET_NAME=%4
set BUILD_TYPE=%5
set TARGET=%6

if "%1" equ "" (
    rem ob`𒼐ڋNƂ̃ftHgl
    set SPEC=NX
    set OS=win32
    set ADDRESS=64
    set BUILD_TARGET_NAME=NX-x64-v140
    set BUILD_TYPE=Develop
)

set SIGLO_ROOT=%~dp0..\..\..\..\..\..\..
set G3DDEMO_ROOT=%SIGLO_ROOT%\Samples\Sources\Applications\G3dDemo
set OPTIMIZER=%SIGLO_ROOT%\Tools\Graphics\3dTools\3dIntermediateFileOptimizer.exe
set CONTENT_DIR=%SIGLO_ROOT%\Tests\Outputs\%BUILD_TARGET_NAME%\Tests\testG3d_ScreenCaptureLod\%BUILD_TYPE%\Contents
set SAMPLE_CONTENT_DIR=%SIGLO_ROOT%\Samples\Sources\Applications\G3dDemo\TempResources\%BUILD_TARGET_NAME%

if "%TARGET%" equ "" (
    set TARGET=Build
)

echo %BUILD_TARGET_NAME% | "%WINDIR%\System32\find.exe" "v140" > NUL
if not errorlevel 1 (
    set VS_VERSION=VS2015
)

if %VS_VERSION%==VS2013 (
    call "%VS120COMNTOOLS%vsvars32.bat"
)
if %VS_VERSION%==VS2015 (
    call "%VS140COMNTOOLS%vsvars32.bat"
) 

if %SPEC%==Generic (
    set PROJFILE=%G3DDEMO_ROOT%\ConvertDemoResources-spec.Generic.csproj
    set CONFIGURATION=%VS_VERSION%_Release
) else (
    set PROJFILE=%G3DDEMO_ROOT%\ConvertDemoResources-spec.NX.csproj
    set CONFIGURATION=NX_%VS_VERSION%_RELEASE
)

if %OS%==win32 if %ADDRESS%==32 (
    set PLATFORM=Win32
) 
if %OS%==win32 if %ADDRESS%==64 (
    set PLATFORM=x64
)
if %OS%==horizon if %ADDRESS%==32 (
    set PLATFORM=NX32
)
if %OS%==horizon if %ADDRESS%==64 (
    set PLATFORM=NX64
)

rem bg_WhiteTown.fmdb ̃obNAbv
set TEST_MODEL=%G3DDEMO_ROOT%\Resources\town\bg_WhiteTown\bg_WhiteTown.fmdb
set TEMPORARY_BACKUP_FILE=%~dp0Temporary.fmdb
copy /Y %TEST_MODEL% %TEMPORARY_BACKUP_FILE% > NUL

rem |S_NVKp
%OPTIMIZER% %TEST_MODEL% --polygon-reduction --polygon-reduction-options "--target-rate-lod-level1 0.5 --target-rate-lod-level2 0.25 --property-flag Position|UV|Normal --optimize-position-policy OptimalOnSpace --uv-weight 0.04 --lock-uv-hard-edge-angle 90"

rem \[XRo[g
set RESULT=0
msbuild %PROJFILE% /t:%TARGET% /p:Configuration=%CONFIGURATION% /p:Platform=%PLATFORM%
if errorlevel 1 set RESULT=%ERRORLEVEL%

rem bg_WhiteTown.fmdb ɖ߂
copy /Y %TEMPORARY_BACKUP_FILE% %TEST_MODEL% > NUL
del %TEMPORARY_BACKUP_FILE%

mkdir %CONTENT_DIR% > NUL 2>&1
xcopy /I /Y /S %SAMPLE_CONTENT_DIR% %CONTENT_DIR%

exit /b %RESULT%
