﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/gfx.h>

namespace nnt{ namespace g3d{

    class FrameCapture
    {
    public:
        FrameCapture();
        ~FrameCapture();
        void Initialize(
            nn::gfx::Device* pDevice,
            nn::gfx::MemoryPool* pMemoryPool,
            nn::util::BytePtr* pMemoryPoolBase,
            nn::util::BytePtr* pMemoryPoolCurrent,
            int screenWidth,
            int screenHeight);
        void Finalize();

        /**
         * @brief 画面のキャプチャを行うコマンドを挿入します。
         */
        void PushCaptureCommand(nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::Texture* pSrcTexture);
        /**
         * @brief キャプチャした画面を内部バッファに転送します。
         */
        void FetchCaptureResult();

        /**
         * @brief 最後にキャプチャした画像を指定したパスに jpeg で書き出します。
         */
        void SaveToJpeg(const char* destPath);

        /**
         * @brief 最後にキャプチャした画像を指定したパスに png で書き出します。
         */
        void SaveToPng(const char* destPath);

    private:
        void* AllocateMemory(size_t size, int alignment);
        void  DeallocateMemory(void* ptr);

        static void* DefaultAllocateFunction(size_t size, int alignment, void* userParam);
        static void  DefaultDeallocateFunction(void* ptr, void* userParam);

    private:
        bool m_IsInitialized;

        void* (*m_AllocateFunction)(size_t size, int alignment, void* userParam);
        void* m_AllocateUserParam;
        void (*m_DeallocateFunction)(void* ptr, void* userParam);
        void* m_DeallocateUserParam;

        int m_ScreenWidth;
        int m_ScreenHeight;

        nn::gfx::Device* m_pDevice;
        nn::gfx::MemoryPool* m_pMemoryPool;
        nn::gfx::Buffer m_CaptureBuffer;

        uint8_t* m_CapturedImageBuffer;
        size_t m_CapturedImageBufferSize;
        void* m_CompressionWorkBuffer;
        size_t m_CompressionWorkBufferSize;
        void* m_CompressedImageBuffer;
        size_t m_CompressedImageBufferSize;
    };

}}
