﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testEft_FrameCapture.h"
#include "framework/testEft_RenderSystem.h"
#include "framework/testEft_EffectSystem.h"

namespace nnt{
namespace eft{

/**
 * @brief キャプチャークラス
 *
 * @details Windows版のみの実装です
 */
class TestEftCapture
{
public:
    /**
     * @brief コンストラクタ
     *
     */
    TestEftCapture();

    /**
     * @brief デストラクタ
     *
     */
    ~TestEftCapture();

    /**
     * @brief 初期化
     *
     * @param[in] heapHandle     ヒープハンドル
     * @param[in] pRenderSystem  描画システムのポインタ
     * @param[in] pEffectSystem  エフェクトシステム
     * @return     成功したときtrueを返します。
     */
    bool Initialize(
        EftRenderSystem* pRenderSystem,
        EffectSystem* pEffectSystem,
        FrameCapture* pFrameCapture );

    /**
     * @brief 解放処理
     *
     */
    void Finalize();

    /**
     * @brief 実行
     *
     * @param[in] outPath          出力先パス
     * @param[in] captureCount     キャプチャーする数
     * @param[in] captureFrame     キャプチャーするフレーム
     */
    void Run( const char* outPath, int captureCount, float captureFrame[] );

private:

    EftRenderSystem*              m_pRenderSystem;        //!< 描画システム
    EffectSystem*                 m_pEffectSystem;        //!< エフェクトシステム
    FrameCapture*                 m_pFrameCapture;        //!< キャプチャクラス
};

}
}
