﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nw/eft/typeDef2.h>


//------------------------------------------------------------------------------
//! @brief  イメージをPNGに保存します。
//!
//! @param[in] width  イメージの横幅
//! @param[in] height イメージの縦幅
//! @param[in] pImage イメージデータ
//! @param[in] pPath  ファイルパス
//! @return 保存に成功したときtrueを返します。
//------------------------------------------------------------------------------
bool WritePng( u32 width, u32 height, const u8* pImage, const char* pPath );

//------------------------------------------------------------------------------
//! @brief  イメージをPNGから入力します。
//!
//! @param[in] width  イメージの横幅
//! @param[in] height イメージの縦幅
//! @param[in] pImage イメージデータ
//! @param[in] pPath  ファイルパス
//! @param[in] heap   ヒープ
//! @return 入力に成功したときtrueを返します。
//------------------------------------------------------------------------------
bool ReadPng( u32& width, u32& height, u8** pImage, const char* pPath, nw::eft2::Heap* heap );
