﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cctype>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nnt.h>
#include <nnt/teamcity/testTeamcity_Logger.h>

// Siglo 環境での警告抑止用
#if defined(NN_BUILD_CONFIG_OS_WIN32)
#pragma warning(push)
#pragma warning(disable : 4244)
#pragma warning(disable : 4668)
#pragma warning(disable : 4702)
#endif

uint32_t    g_WaitTimeMilliSecond = 0;

//----------------------------------------------------------------------------------------------------
TEST(WaitTest, WaitTest)
{
    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(g_WaitTimeMilliSecond));

    SUCCEED();
}

//----------------------------------------------------------------------------------
//  NX 実機テスト実行中に指定された時間ウエイトをかけるテストプログラムです。
//----------------------------------------------------------------------------------
extern "C" void nnMain()
{
    int argc = nn::os::GetHostArgc();//::nnt::GetHostArgc();
    char** argv = nn::os::GetHostArgv();//::nnt::GetHostArgv();

    NN_LOG("Running nnMain() from testGraphics_WaitTest.cpp\n");
    ::testing::InitGoogleTest(&argc, argv);

    ::testing::TestEventListeners& listeners =
        ::testing::UnitTest::GetInstance()->listeners();
    ::testing::TestEventListener* defaultResultPrinter =
        listeners.Release(listeners.default_result_printer());
#if defined(NN_BUILD_CONFIG_HARDWARE_BDSLIMX6) || defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK1) || defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || defined(NN_BUILD_CONFIG_HARDWARE_NX)
    listeners.Append(new ::nnt::teamcity::ServiceMessageLogger());
#endif
    listeners.Append(defaultResultPrinter);

    // コマンドライン引数の解析
    for(int i = 1; i < argc; i++)
    {
        NN_LOG("argv[%d] = %s\n", i, argv[i]);
        const char* arg = argv[i];
        if(std::strcmp(arg, "--wait-time") == 0)
        {
            NN_ASSERT(i + 1 < argc);
            NN_LOG("argv[%d] = %s\n", i + 1, argv[i + 1]);
            g_WaitTimeMilliSecond = atoi(argv[i + 1]);
            i += 1;
        }
    }

    int result = RUN_ALL_TESTS();

    ::nnt::Exit(result);
}
