﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include "testGraphics_ImageInformation.h"

namespace nnt{ namespace graphics{

    class PixelwiseImageComparison
    {
    public:
        class Parameter
        {
        public:
            Parameter() NN_NOEXCEPT;
            void SetDefault() NN_NOEXCEPT;

            int GetColorTolerance() const NN_NOEXCEPT;
            void SetColorTolerance(int value) NN_NOEXCEPT;

            int GetDisplacementTolerance() const NN_NOEXCEPT;
            void SetDisplacementTolerance(int value) NN_NOEXCEPT;

            // 比較結果を最大値で埋めるかどうか
            bool IsResultFilledWithMaximum() const NN_NOEXCEPT;
            void SetResultFilledWithMaximum(bool value) NN_NOEXCEPT;

        private:
            int m_ColorTolerance;
            int m_DisplacementTolerance;
            bool m_IsResultFilledWithMaximum;
        };

    public:
        //! @brief ピクセル単位で比較を行います。
        //! @param[out] resultImg 比較結果を保存する画像
        //! @param[in] img0 比較する1つ目の画像
        //! @param[in] img1 比較する2つ目の画像
        //! @param[in] tol チャンネルごとの誤差の許容量
        //! @pre resultImg が有効な画像
        //! @pre img0 が有効な画像
        //! @pre img1 が有効な画像
        //! @pre 各画像の width, height, nChannels, channelSize がそれぞれ等しい
        //! @pre channelSize == 1
        //! @return 等しくないピクセルの数を返します。
        static int Compare(
            ImageInformation* resultImg,
            const ImageInformation* img0,
            const ImageInformation* img1,
            const Parameter* param) NN_NOEXCEPT;
    };

}}
