﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <iostream>
#include "testGraphics_ImageIo.h"
namespace nnt{ namespace graphics{

    struct BMP_IHDR
    {
        char bfType[2];
        uint32_t bfSize;
        uint16_t bfReserved1;
        uint16_t bfReserved2;
        uint32_t bfOffBits;

        uint32_t biSize;
        uint32_t biWidth;
        int32_t  biHeight;
        uint16_t biPlanes;
        uint16_t biBitCount;
        uint32_t biCompression;

        /**
         * @brief ピクセル深度の取得
         *
         * @return     ピクセル深度を返します。
        */
        uint8_t GetPixelDepth() const { return static_cast<uint8_t>( biBitCount ); }

        /**
         * @brief 1行あたりのバイト数を取得
         *
         * @return     1行あたりのバイト数を返します。
        */
        uint32_t GetRowBytes() const { return ((biWidth * static_cast<uint32_t>(GetPixelDepth()) + 7) >> 3); }
    };

    /**
    * @brief BMP 入出力
    *
    * @details
    */
    class BmpIo : ImageIo
    {
    public:
        /**
         * @brief カラータイプ
         */
        enum BMP_COLOR_TYPE
        {
            BMP_COLOR_TYPE_GRAY         = 0,    //!< グレイスケール
            BMP_COLOR_TYPE_PALETTE      = 1,    //!< パレット
            BMP_COLOR_TYPE_RGB          = 2,    //!< RGB
            BMP_COLOR_TYPE_RGB_ALPHA    = 3,    //!< RGB+アルファ
            BMP_COLOR_TYPE_GRAY_ALPHA   = 4     //!< グレイスケール+アルファ
        };

        /**
         * @brief BMP ファイル読み込み
         *
         * @param[out] pImage        イメージデータ
         * @param[in]  pPath         ファイルパス
         * @return     入力に成功したときtrueを返します。
        */
        static bool ReadBmp( uint8_t** pImage, const char* pPath);

        /**
         * @brief BMP ファイル読み込み
         *
         * @param[out] pImage        イメージデータ
         * @param[in]  pPath         ファイルパス
         * @param[out] ihdr          BMP のIHDRデータ
         * @return     入力に成功したときtrueを返します。
        */
        static bool ReadBmp( uint8_t** pImage, const char* pPath, BMP_IHDR& ihdr );
    };
}}
