﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Base.h>
#include <nn/nn_Log.h>

#include <nn/os.h>

#include <nn/gpio/gpio.h>
#include <nn/gpio/gpio_PadAccessorDev.h>

#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>

#include "../common/testGpio_Util.h"

namespace
{

// テスト用 pinmux ライブラリ
nnt::gpio::Pinmux g_Pinmux;

}

//-----------------------------------------------------------------------------
// GPIO ライブラリの同じレジスタに乗っているパッドを複数操作して他に影響を与えていないことを確認するテスト
TEST(testGpio_Concurrent, Output)
{
    // セッション用の構造体の配列
    nn::gpio::GpioPadSession session[nnt::gpio::NumberOfTestPad];

    // ライブラリ自体の Initialize
    nn::gpio::Initialize();

    // セッションをオープンし、すべて Output 方向にする。
    for(int i = 0; i < nnt::gpio::NumberOfTestPad; i++)
    {
#if (defined(NN_GPIO_GEN) && (NN_GPIO_GEN == 2))
        NNT_ASSERT_RESULT_SUCCESS(nn::gpio::OpenSession(&session[i], nnt::gpio::PadNameList[i]));
#else // gen1
        nn::gpio::OpenSessionForDev(&session[i], static_cast<int>(nnt::gpio::PadNameList[i]));
#endif
        nn::gpio::SetDirection(&session[i], nn::gpio::Direction_Output);
    }

    for(int i = 0; i < nnt::gpio::NumberOfTestPad; i++)
    {
        // 全て Output になっているか確認
        ASSERT_EQ(nn::gpio::Direction_Output, nn::gpio::GetDirection(&session[i]));
    }

    // 偶数は High、奇数は Low にする
    for(int i = 0; i < nnt::gpio::NumberOfTestPad; i++)
    {
        // Pinmux でループバックに設定する。
        g_Pinmux.SetDirectionForLoopBack(nnt::gpio::PadNameList[i]);

        if(i % 2 == 0)
        {
            nn::gpio::SetValue(&session[i], nn::gpio::GpioValue_High);
        }
        else
        {
            nn::gpio::SetValue(&session[i], nn::gpio::GpioValue_Low);
        }

    }

    // 想定通りになっていることを確認する
    for(int i = 0; i < nnt::gpio::NumberOfTestPad; i++)
    {
        if(i % 2 == 0)
        {
            ASSERT_EQ(nn::gpio::GpioValue_High, nn::gpio::GetValue(&session[i]));
        }
        else
        {
            ASSERT_EQ(nn::gpio::GpioValue_Low, nn::gpio::GetValue(&session[i]));
        }

        nn::gpio::CloseSession(&session[i]);
    }

    nn::gpio::Finalize();

}

