﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>

#include <nn/nn_Common.h>
#include <nn/gfx0.h>

namespace nn { namespace gfx0 {
// InitializeGfx0Driver() を DFC 用に初期化するテスト用の隠し API です。
// この関数は公開ヘッダではプロトタイプ宣言されていません。
void InitializeGfx0DriverByDfcForTest() NN_NOEXCEPT;
}}

TEST(Gfx0Skeleton, Basic_DummyFuncGfx0ByDfc)
{
    for (auto i = 0; i < 100; ++i)
    {
        nn::gfx0::InitializeGfx0DriverByDfcForTest();
        auto ret = nn::gfx0::DummyFuncGfx0(i , i * 2);
        EXPECT_EQ( i * 3, ret );
        nn::gfx0::FinalizeGfx0Driver();
    }
}

