﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testGc_Unit_GcLibrary_Util.h"
#include <nn/gc/detail/gc_AsicHandler.h>

extern char*     g_DataBuffer;

//TEST(GcUnitTest, ActivateDeactivate)
//{
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::Activate());
//    nn::gc::Deactivate();
//}
//TEST(GcUnitTest, OnePath)
//{
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::Activate());
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::Read(g_DataBuffer, DataBufferSize, 0, 2));
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::SetCardToSecureMode());
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::Read(g_DataBuffer, DataBufferSize, 0x80000, 2));
//    nn::gc::Deactivate();
//}

// ABORT

//TEST(GcUnitTest, DoubleActivate)
//{
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::Activate());
//    nn::Result result = nn::gc::Activate();
//    if(result.IsFailure())
//    {
//        NN_LOG("  Activate Failure (Module:%d, Description:%d)\n", result.GetModule(), result.GetDescription());
//    }
//    nn::gc::Deactivate();
//}

// ABORT

//TEST(GcUnitTest, SetCardToSecureModeWithoutActivate)
//{
//    NN_LOG("SetCardToSecureModeWithoutActivate Start\n");
//    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(800));
//    NN_LOG("SetCardToSecureMode Start\n");
//    nn::Result result = nn::gc::SetCardToSecureMode();
//    if(result.IsFailure())
//    {
//        NN_LOG("  SetCardToSecureMode Failure (Module:%d, Description:%d)\n", result.GetModule(), result.GetDescription());
//    }
//}

// ABORT

//TEST(GcUnitTest, ReadWithoutActivate)
//{
//    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(800));
//    nn::Result result = nn::gc::Read(g_DataBuffer, DataBufferSize, 0, 2);
//    if(result.IsFailure())
//    {
//        NN_LOG("  Read Failure (Module:%d, Description:%d)\n", result.GetModule(), result.GetDescription());
//    }
//}

//TEST(GcUnitTest, ReadSecureWithoutSetCardToSecureMode)
//{
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::Activate());
//    nn::Result result = nn::gc::detail::AsicHandler::GetInstance().OrderWorkRead(g_DataBuffer, DataBufferSize, 0x80000, 2);
//    ASSERT_TRUE(ResultGameCardInvalidSecureAccess::Includes(result));
//}

//TEST(GcUnitTest, ReadNormalAfterSetCardToSecureMode)
//{
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::Activate());
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::SetCardToSecureMode());
//    nn::Result result = nn::gc::detail::AsicHandler::GetInstance().OrderWorkRead(g_DataBuffer, DataBufferSize, 0, 2);
//    ASSERT_TRUE(ResultGameCardInvalidNormalAccess::Includes(result));
//}

//TEST(GcUnitTest, ReadAccross2Area)
//{
//    const size_t ReadPageSize = 0x8;
//    nn::gc::detail::AsicHandler::GetInstance().Initialize();
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::detail::AsicHandler::GetInstance().OrderWork(nn::gc::detail::AsicWork_Activate));
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::detail::AsicHandler::GetInstance().OrderWork(nn::gc::detail::AsicWork_SetCardToSecureMode));
//    nn::Result result = nn::gc::detail::AsicHandler::GetInstance().OrderWorkRead(g_DataBuffer, DataBufferSize, 0x80000 - ReadPageSize / 2, ReadPageSize);
//    ASSERT_TRUE(ResultGameCardInvalidAccessAcrossMode::Includes(result));
//}

//TEST(GcUnitTest, SleepCheck)
//{
//    for(int i = 0; i < 50; i++)
//    {
//        NN_TESTGC_EXPECT_SUCCESS(nn::gc::Activate());
//        nn::gc::Deactivate();
//        NN_TESTGC_EXPECT_SUCCESS(nn::gc::GoToSleep());
//        NN_TESTGC_EXPECT_SUCCESS(nn::gc::WakeUp());
//    }
//}

//TEST(GcUnitTest, SleepCheck)
//{
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::GoToSleep());
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::WakeUp());
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::Activate());
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::GoToSleep());
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::WakeUp());
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::Read(g_DataBuffer, DataBufferSize, 0, 2));
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::GoToSleep());
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::WakeUp());
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::SetCardToSecureMode());
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::GoToSleep());
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::WakeUp());
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::Read(g_DataBuffer, DataBufferSize, 0x80000, 2));
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::GoToSleep());
//    NN_TESTGC_EXPECT_SUCCESS(nn::gc::WakeUp());
//    nn::gc::Deactivate();
//    //        NN_TESTGC_EXPECT_SUCCESS(nn::gc::GoToSleep());
//    //        NN_TESTGC_EXPECT_SUCCESS(nn::gc::WakeUp());
//}
