﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_TimeSpan.h>

#include <nn/hid/system/hid_RegisteredDevice.h>
#include <nn/hid/system/hid_UniquePad.h>

#include <nn/os/os_Thread.h>

#include <nn/TargetConfigs/build_Base.h>

#include <nnt/nntest.h>

#include "../Common/testGamePad_Common.h"

namespace
{

} // namespace

//!< 本体ジョイント, 有線ペアリングで正しくペアリング情報を登録できるか
TEST(Smoke, WiredPairing)
{
    ::nn::hid::system::RegisteredDevice registeredDevices[::nn::hid::system::RegisteredDeviceCountMax] = {};

    const auto RegisteredDeviceCount = ::nn::hid::system::GetRegisteredDevices(registeredDevices,
                                                                               NN_ARRAY_SIZE(registeredDevices));

    NN_LOG("# of pairing devices : %d\n", ::nnt::gamepad::DevicePairingCountMax);
    NN_LOG("# of paired devices : %d\n", RegisteredDeviceCount);

    ::nnt::gamepad::PrintRegisteredDevices();

    ASSERT_EQ(::nnt::gamepad::DevicePairingCountMax, RegisteredDeviceCount);
}

//!< Pro コントローラ USB 通信の有効化・無効化が正しく動作するか
TEST(Smoke, ChangeUsbConnectionConfig)
{
    ::nnt::gamepad::EnableUsbConnect();
    ::nnt::gamepad::DisableUsbConnect();
}

//!< USB コントローラの自動接続・切断が正しく動作するか
TEST(Smoke, UsbPadsConnection)
{
    ::nnt::gamepad::Initialize();

    ::nnt::gamepad::ConnectUsbPads();

    int UsbPadsCount = ::nnt::gamepad::GetConnectedUsbPadsCount();

    ASSERT_EQ(::nnt::gamepad::UsbPadsCountMax, UsbPadsCount);
    NN_LOG("Expected: %d, Actual: %d\n", ::nnt::gamepad::UsbPadsCountMax, UsbPadsCount);

    ::nnt::gamepad::DisconnectUsbPads();

    UsbPadsCount = ::nnt::gamepad::GetConnectedUsbPadsCount();

    ASSERT_EQ(0, UsbPadsCount);
    NN_LOG("Expected: %d, Actual: %d\n", 0, UsbPadsCount);
}

//!< ::nnt::gamepad が提供する API が正しく動作するか
TEST(Smoke, ConnectionTrigger)
{
    // 接続中コントローラのユニークID
    ::nn::hid::system::UniquePadId uniquePadIds[::nn::hid::system::UniquePadIdCountMax];
    // 接続中のコントローラ数
    int ConnectedDeviceCount;

    // Npad の初期化
    ::nnt::gamepad::Initialize();


    // ProCon USB 無効
    ::nnt::gamepad::DisableUsbConnect();

    // コントローラの再接続
    ::nnt::gamepad::DisconnectAll();
    ::nnt::gamepad::ConnectAll();

    // 全てのデバイスが接続されたか
    ConnectedDeviceCount = ::nn::hid::system::ListUniquePads(uniquePadIds, NN_ARRAY_SIZE(uniquePadIds));

    ::nnt::gamepad::PrintUniquePads();

    ASSERT_EQ(ConnectedDeviceCount, ::nnt::gamepad::DeviceCountMax);
    NN_LOG("%d/%d Devices are connected\n", ConnectedDeviceCount, ::nnt::gamepad::DeviceCountMax);


    // ProCon USB 有効
    ::nnt::gamepad::EnableUsbConnect();

    // コントローラの再接続
    ::nnt::gamepad::DisconnectAll();
    ::nnt::gamepad::ConnectAll();

    // 全てのデバイスが接続されたか
    ConnectedDeviceCount = ::nn::hid::system::ListUniquePads(uniquePadIds, NN_ARRAY_SIZE(uniquePadIds));

    ASSERT_EQ(ConnectedDeviceCount, ::nnt::gamepad::DeviceCountMax);
    NN_LOG("%d/%d Devices are connected\n", ConnectedDeviceCount, ::nnt::gamepad::DeviceCountMax);

    ::nnt::gamepad::DisconnectAll();
}
