﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/TargetConfigs/build_Base.h>

namespace nnt { namespace gamepad {

//!< SixAxisSensor のサンプリング間隔を返します。
inline ::nn::TimeSpanType GetSixAxisSensorSamplingInterval() NN_NOEXCEPT
{
    return ::nn::TimeSpanType::FromMilliSeconds(5);
}

//!< 6軸センサーの入力状態を出力します。
void PrintSixAxisSensorState(const nn::hid::SixAxisSensorState& state)
{
    NN_LOG("SamplingNumber:%lld, DeltaTime[us]:%lld\n",
        state.samplingNumber,
        state.deltaTime.GetMicroSeconds());
    NN_LOG("IsConnected:%s\n",
        state.attributes.Test<::nn::hid::SixAxisSensorAttribute::IsConnected>() ? "True" : "False");
    NN_LOG("Acc: %f, %f, %f\n", state.acceleration.x,
        state.acceleration.y,
        state.acceleration.z);
    NN_LOG("Gyro: %f, %f, %f\n", state.angularVelocity.x,
        state.angularVelocity.y,
        state.angularVelocity.z);
    NN_LOG("Angle: %f, %f, %f\n", state.angle.x,
        state.angle.y,
        state.angle.z);
    NN_LOG("Direction.x: %f, %f, %f\n", state.direction.x.x,
        state.direction.x.y,
        state.direction.x.z);
    NN_LOG("Direction.y: %f, %f, %f\n", state.direction.y.x,
        state.direction.y.y,
        state.direction.y.z);
    NN_LOG("Direction.z: %f, %f, %f\n", state.direction.z.x,
        state.direction.z.y,
        state.direction.z.z);
    NN_LOG("\n");
}

}} // namespace nnt::gamepad
