﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Tick.h>
#include <nn/os/os_Thread.h>
#include <nn/irsensor.h>
#include <nn/irsensor/irsensor_IrLedProcessorApi.h>
#include <nn/irsensor/irsensor_AdaptiveClusteringProcessor.h>
#include <nnt.h>

#if defined(NN_BUILD_CONFIG_OS_WIN32)
#define NNT_IRSENSOR_EXIT_0 ::testing::ExitedWithCode(0)
#define NNT_IRSENSOR_EXIT_SUCCESS exit(0)
#define NNT_IRSENSOR_EXPECT_EXIT(statement, predicate, regex) EXPECT_EXIT(statement, predicate, regex)
#else
#define NNT_IRSENSOR_EXIT_SUCCESS /* 何もしない */
#define NNT_IRSENSOR_EXPECT_EXIT(statement, predicate, regex) statement
#endif

namespace nnt { namespace irsensor {

class IrSensorTest : public ::testing::Test
{
protected:
    virtual void SetUp() NN_NOEXCEPT
    {
        nn::hid::InitializeNpad();

        nn::hid::SetSupportedNpadIdType(nnt::gamepad::NpadIds, nnt::gamepad::NpadIdCountMax);

        s_HandleCount = nnt::gamepad::NpadIdCountMax;

        for (auto i = 0; i < s_HandleCount; ++i)
        {
            auto id = nnt::gamepad::NpadIds[i];
            s_Handles[i] = nn::irsensor::GetIrCameraHandle(id);
            nn::irsensor::Initialize(s_Handles[i]);
        }
    }

    virtual void TearDown() NN_NOEXCEPT
    {
        for (auto i = 0; i < s_HandleCount; ++i)
        {
            nn::irsensor::Finalize(s_Handles[i]);
        }
    }

protected:
    // specs=NX のときに Typed Test がメンバにアクセスできないので
    // 静的変数にしてアクセスできるようにする
    static nn::irsensor::IrCameraHandle s_Handles[nnt::gamepad::NpadIdCountMax];
    static int s_HandleCount;
};

}} // namaspace nnt::irsensor
