﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nnt/gtest/gtest.h>
#include <nnd/ftm/ftm.h>

namespace nnt { namespace ftm {

// Initialize() を繰り返し呼んでも落ちないことのテスト
TEST(InitializeTest, Repeat)
{
    using namespace nnd::ftm;

    Initialize();
    Initialize();

    Finalize();
}

// ResetDevice() を繰り返し呼んでも落ちないことのテスト
TEST(ResetDeviceTest, Repeat)
{
    using namespace nnd::ftm;

    Initialize();

    nn::Result result = ResetDevice();
    EXPECT_TRUE(result.IsSuccess());
    result = ResetDevice();
    EXPECT_TRUE(result.IsSuccess());

    Finalize();
}

// SleepOutDevice() を繰り返し呼んでも落ちないことのテスト
TEST(SleepOutDevice, Repeat)
{
    using namespace nnd::ftm;

    Initialize();

    nn::Result result = ResetDevice();
    EXPECT_TRUE(result.IsSuccess());

    result = SleepOutDevice();
    EXPECT_TRUE(result.IsSuccess());
    result = SleepOutDevice();
    EXPECT_TRUE(result.IsSuccess());

    result = ResetDevice();
    EXPECT_TRUE(result.IsSuccess());
    Finalize();
}

// SleepInDevice() を繰り返し呼んでも落ちないことのテスト
TEST(SleepInDevice, Repeat)
{
    using namespace nnd::ftm;

    Initialize();

    nn::Result result = ResetDevice();
    EXPECT_TRUE(result.IsSuccess());

    result = SleepOutDevice();
    EXPECT_TRUE(result.IsSuccess());

    result = SleepInDevice();
    EXPECT_TRUE(result.IsSuccess());
    result = SleepInDevice();
    EXPECT_TRUE(result.IsSuccess());

    Finalize();
}

// ActivateSensing() を繰り返し呼んでも落ちないことのテスト
TEST(ActivateSensingTest, Repeat)
{
    using namespace nnd::ftm;

    Initialize();

    nn::Result result = ResetDevice();
    EXPECT_TRUE(result.IsSuccess());

    result = SleepOutDevice();
    EXPECT_TRUE(result.IsSuccess());

    result = ActivateSensing();
    EXPECT_TRUE(result.IsSuccess());
    result = ActivateSensing();
    EXPECT_TRUE(result.IsSuccess());

    result = DeactivateSensing();
    EXPECT_TRUE(result.IsSuccess());

    result = ResetDevice();
    EXPECT_TRUE(result.IsSuccess());
    Finalize();
}

// ReadEventReports() を繰り返し呼んでも落ちないことのテスト
TEST(ReadEventReportsTest, Repeat)
{
    using namespace nnd::ftm;

    Initialize();

    nn::Result result = ResetDevice();
    EXPECT_TRUE(result.IsSuccess());

    result = SleepOutDevice();
    EXPECT_TRUE(result.IsSuccess());

    result = ActivateSensing();
    EXPECT_TRUE(result.IsSuccess());

    char readData[FtmMaxEventReportCount * FtmMaxEventReportByteSize];
    int leftCount;
    int readCount;
    bool isOverflow;
    result = ReadEventReports(readData, &leftCount, &readCount, &isOverflow, GetMaxEventReportCount());
    EXPECT_TRUE(result.IsSuccess());
    result = ReadEventReports(readData, &leftCount, &readCount, &isOverflow, GetMaxEventReportCount());
    EXPECT_TRUE(result.IsSuccess());

    result = DeactivateSensing();
    EXPECT_TRUE(result.IsSuccess());

    result = ResetDevice();
    EXPECT_TRUE(result.IsSuccess());

    Finalize();
}

// ParseEventReports() を繰り返し呼んでも落ちないことのテスト
TEST(ParseEventReportsTest, Repeat)
{
    using namespace nnd::ftm;

    Initialize();

    nn::Result result = ResetDevice();
    EXPECT_TRUE(result.IsSuccess());

    result = SleepOutDevice();
    EXPECT_TRUE(result.IsSuccess());

    result = ActivateSensing();
    EXPECT_TRUE(result.IsSuccess());

    char readData[FtmMaxEventReportCount * FtmMaxEventReportByteSize];
    int leftCount;
    int readCount;
    bool isOverflow;
    result = ReadEventReports(readData, &leftCount, &readCount, &isOverflow, GetMaxEventReportCount());
    EXPECT_TRUE(result.IsSuccess());

    EventReport report[FtmMaxEventReportCount];
    ParseEventReports(report, readData, readCount);
    ParseEventReports(report, readData, readCount);

    result = DeactivateSensing();
    EXPECT_TRUE(result.IsSuccess());

    result = ResetDevice();
    EXPECT_TRUE(result.IsSuccess());

    Finalize();
}

// DeactivateSensing() を繰り返し呼んでも落ちないことのテスト
TEST(DeactivateSensingTest, Repeat)
{
    using namespace nnd::ftm;

    Initialize();

    nn::Result result = ResetDevice();
    EXPECT_TRUE(result.IsSuccess());

    result = SleepOutDevice();
    EXPECT_TRUE(result.IsSuccess());

    result = ActivateSensing();
    EXPECT_TRUE(result.IsSuccess());

    result = DeactivateSensing();
    EXPECT_TRUE(result.IsSuccess());
    result = DeactivateSensing();
    EXPECT_TRUE(result.IsSuccess());

    result = ResetDevice();
    EXPECT_TRUE(result.IsSuccess());

    Finalize();
}

// Finalize() が一度しか呼べないことのテスト
TEST(FinalizeTest, Repeat)
{
    using namespace nnd::ftm;

    Initialize();

    Finalize();
    EXPECT_DEATH_IF_SUPPORTED(Finalize(), "");
}

// BindInterrupt() が一度しか呼べないことのテスト
TEST(BindInterruptTest, Repeat)
{
    using namespace nnd::ftm;

    Initialize();

    nn::os::SystemEventType event;
    nn::Result result = BindInterrupt(&event);
    EXPECT_TRUE(result.IsSuccess());
    result = BindInterrupt(&event);
    EXPECT_FALSE(result.IsSuccess());

    result = UnbindInterrupt();
    EXPECT_TRUE(result.IsSuccess());

    Finalize();
}

// UnbindInterrupt() を繰り返し呼んでも落ちないことのテスト
TEST(UnbindInterruptTest, Repeat)
{
    using namespace nnd::ftm;

    Initialize();
    nn::os::SystemEventType event;
    nn::Result result = BindInterrupt(&event);
    EXPECT_TRUE(result.IsSuccess());

    result = UnbindInterrupt();
    EXPECT_TRUE(result.IsSuccess());
    result = UnbindInterrupt();
    EXPECT_TRUE(result.IsSuccess());

    Finalize();
}

}}
