﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/result/result_HandlingUtility.h>
#include <nnd/ftm/ftm.h>

#define FW_ERASE_ENABLE

extern "C" void nnMain()
{
    NN_LOG("/// FTM Fw Eraser ///\n");

    #ifndef FW_ERASE_ENABLE
        NN_LOG("FwEraser has been finished, but a fw has not been erased.\n"
               "Please enable the FW_ERASE_ENABLE macro if you really want to erase it.\n");
        return;
    #endif

    nnd::ftm::Initialize();

    nn::Result result = nnd::ftm::ResetDevice();
    if (result.IsFailure())
    {
        NN_LOG("Module : %d, Description : %d, Inner : %d\n",
               result.GetModule(), result.GetDescription(), result.GetInnerValueForDebug());
    }

    result = nnd::ftm::EraseFirmware();
    if (result.IsFailure())
    {
        NN_LOG("Module : %d, Description : %d, Inner : %d\n",
               result.GetModule(), result.GetDescription(), result.GetInnerValueForDebug());
    }

    nnd::ftm::Finalize();

    NN_LOG("[[ PASSED !! ]]\n");
}
