﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs.h>
#include <nn/fssystem/fs_AsynchronousAccess.h>
#include <nn/fssystem/save/fs_IntegritySaveDataFileSystem.h>
#include <nn/fssystem/save/fs_HierarchicalIntegrityVerificationStorage.h>
#include <nn/crypto.h>
#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/fsUtil/testFs_util.h>

extern "C" void nnMain()
{
    typedef nn::fssystem::save::HierarchicalIntegrityVerificationStorage VerificationStorage;

    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

    static const size_t HeapSize = 32 * 1024 * 1024;
    static char s_HeapStack[HeapSize];
    nnt::fs::util::InitializeTestLibraryHeap(s_HeapStack, HeapSize);
    nn::fs::SetAllocator(nnt::fs::util::Allocate, nnt::fs::util::Deallocate);
    nnt::fs::util::ResetAllocateCount();

    // nn::fssystem::InitializeBufferPool() を呼び出すために行う
    nn::fs::MountHostRoot(); // 返り値は見ない
    nn::fs::UnmountHostRoot();

    VerificationStorage::SetGenerateRandomFunction(nnt::fs::util::GenerateRandomForSaveDataTest);

#if defined(NN_BUILD_CONFIG_HARDWARE_NX)
    // PooledBuffer の初期化
    {
        static const size_t BufferPoolSize = 8 * 1024 * 1024;
        static NN_ALIGNAS(4096) char g_BufferPool[BufferPoolSize];
        static const size_t WorkBufferSize = nn::fssystem::BufferPoolWorkSize;
        static NN_ALIGNAS(8) char g_WorkBuffer[WorkBufferSize];
        nn::fssystem::InitializeBufferPool(g_BufferPool, BufferPoolSize, g_WorkBuffer, WorkBufferSize);
    }
#endif // defined(NN_BUILD_CONFIG_HARDWARE_NX)

    auto result = RUN_ALL_TESTS();

    nnt::Exit(result);
}
