﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/fs.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/fssystem/buffers/fs_FileSystemBufferManager.h>

#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/fsUtil/testFs_util.h>
#include <nnt/nnt_Argument.h>

#include "testFs_Unit_DbmLayerTestCase.h"

namespace nnt { namespace fs {
    nn::fssystem::IBufferManager* GetBufferManager() NN_NOEXCEPT
    {
        static nn::fssystem::IBufferManager* s_pBufferManager = nullptr;

        if( s_pBufferManager == nullptr )
        {
            static const auto MaxCacheCount = 1024;
            static const auto SizeBlock = 16 * 1024;
            static const auto BufferManagerHeapSize = 6 * 1024 * 1024;
            static NN_ALIGNAS(4096) char s_BufferManagerHeap[BufferManagerHeapSize];
            static nn::fssystem::FileSystemBufferManager s_BufferManagerInstance;

            s_BufferManagerInstance.Initialize(
                MaxCacheCount,
                reinterpret_cast<uintptr_t>(s_BufferManagerHeap),
                sizeof(s_BufferManagerHeap),
                SizeBlock);
            s_pBufferManager = &s_BufferManagerInstance;
        }

        return s_pBufferManager;
    }
}}

extern "C" void nnMain() NN_NOEXCEPT
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

    auto ret = RUN_ALL_TESTS();

    nnt::Exit(ret);
}

