﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testFs_Stress_StressTest.h"

namespace nnt { namespace fs {

class OpenEntriesTestCase : public FsStressTest::TestCase
{
public:
    static const auto PathLength = 64;

public:
    OpenEntriesTestCase(
        int threadCount,
        int entryCount,
        nn::fs::DirectoryEntryType entryType) NN_NOEXCEPT;
    virtual ~OpenEntriesTestCase() NN_NOEXCEPT NN_OVERRIDE;

    virtual int GetThreadCount() const NN_NOEXCEPT NN_OVERRIDE;

    virtual void SetUp(FsStressTest* pTest) NN_NOEXCEPT NN_OVERRIDE;
    virtual void TearDown(FsStressTest* pTest) NN_NOEXCEPT NN_OVERRIDE;

protected:
    template<size_t Length>
    const char* MakePath(char (&path)[Length], int entryIndex) const NN_NOEXCEPT
    {
        return MakePath(path, Length, entryIndex);
    }

    const char* MakePath(char* path, size_t length, int entryIndex) const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_GREATER_EQUAL(entryIndex, 0);
        nn::util::SNPrintf(
            path,
            length,
            "%s:%s/%s%d",
            GetMountName(),
            GetTestDirectoryPath(),
            m_EntryType == nn::fs::DirectoryEntryType_Directory ? "dir" : "file",
            entryIndex);
        return path;
    }

    int GetEntryCount() const NN_NOEXCEPT
    {
        return m_EntryCount;
    }

    int GetEntryIndex(int threadIndex, int entryIndex) const NN_NOEXCEPT
    {
        return threadIndex * GetEntryCount() + entryIndex;
    }

private:
    nn::fs::DirectoryEntryType m_EntryType;
    int m_ThreadCount;
    int m_EntryCount;
};

}}
