﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testFs_Stress_OpenEntriesTestCase.h"

namespace nnt { namespace fs {

class AccessFilesTestCase : public OpenEntriesTestCase
{
public:
    AccessFilesTestCase(int threadCount, int entryCount, nn::fs::OpenMode mode) NN_NOEXCEPT;
    AccessFilesTestCase(
        int threadCount,
        int entryCount,
        nn::fs::OpenMode mode,
        bool keepOpened) NN_NOEXCEPT;
    AccessFilesTestCase(
        int threadCount,
        int entryCount,
        nn::fs::OpenMode mode,
        bool keepOpened,
        bool isVerificationEnabled,
        bool isCacheEnabled) NN_NOEXCEPT;
    virtual ~AccessFilesTestCase() NN_NOEXCEPT NN_OVERRIDE;

    virtual void SetUp(FsStressTest* pTest) NN_NOEXCEPT NN_OVERRIDE;
    virtual void TearDown(FsStressTest* pTest) NN_NOEXCEPT NN_OVERRIDE;

    void SetUpVerifyBuffer() NN_NOEXCEPT;
    bool Verify(char* path, char* buffer, int64_t offset, size_t size) NN_NOEXCEPT;
    bool Verify(int index, char* buffer, int64_t offset, size_t size) NN_NOEXCEPT;
    void RegisterVerifyBuffer(int index, char* buffer, size_t size) NN_NOEXCEPT;
    bool IsVerificationEnabled() const NN_NOEXCEPT
    {
        return m_IsVerificationEnabled;
    }

protected:
    nn::fs::FileHandle GetFile(int entryIndex) const NN_NOEXCEPT
    {
        return m_Files[entryIndex];
    }

    virtual void SetUpFile(bool* outSucceeded, int entryIndex) NN_NOEXCEPT = 0;

private:
    nn::fs::OpenMode m_Mode;
    nn::fs::FileHandle m_Files[FsStressTest::EntryCountMax];
    bool m_KeepOpened;
    int m_FilesOpenedThreadCount;
    int m_OpenedFileCount;
    bool m_IsVerificationEnabled;
    bool m_IsCacheEnabled;
};

}}
