﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/fs/fs_Debug.h>
#include <nn/fs/fs_ContentStorage.h>

#include <nnt/nntest.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/fsUtil/testFs_util.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/nnt_Argument.h>
#include <nn/fs/fs_FileSystemPrivate.h>

using namespace nn;
using namespace nn::fs;
using namespace nn::fs::detail;
using namespace nnt::fs::util;

namespace {

// 分割ファイルを配置したディレクトリに SetConcatenationFileAttribute して 4GB 超えファイルになること
TEST(SetConcatenationFileAttribute, Set)
{

    NNT_EXPECT_RESULT_SUCCESS(MountContentStorage("content", ContentStorageId::SdCard));
    NNT_EXPECT_RESULT_SUCCESS(MountSdCardForDebug("sd"));

    DeleteDirectoryRecursively("sd:/Nintendo/Contents/file");

    NNT_EXPECT_RESULT_SUCCESS(CreateDirectory("sd:/Nintendo/Contents/file"));
    NNT_EXPECT_RESULT_SUCCESS(CreateFile("sd:/Nintendo/Contents/file/00", 0xFFFF0000));
    NNT_EXPECT_RESULT_SUCCESS(CreateFile("sd:/Nintendo/Contents/file/01", 0x1000));

    {
        DirectoryEntryType type;
        NNT_EXPECT_RESULT_SUCCESS(GetEntryType(&type, "content:/file"));
        EXPECT_EQ(DirectoryEntryType_Directory, type);
    }

    NNT_EXPECT_RESULT_SUCCESS(SetConcatenationFileAttribute("content:/file"));

    {
        DirectoryEntryType type;
        NNT_EXPECT_RESULT_SUCCESS(GetEntryType(&type, "content:/file"));
        EXPECT_EQ(DirectoryEntryType_File, type);
    }

    NNT_EXPECT_RESULT_SUCCESS(DeleteFile("content:/file"));

    Unmount("content");
    Unmount("sd");
}

}

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

    nn::fs::SetAllocator(nnt::fs::util::Allocate, nnt::fs::util::Deallocate);
    nnt::fs::util::ResetAllocateCount();

    auto result = RUN_ALL_TESTS();

    if (nnt::fs::util::CheckMemoryLeak())
    {
        nnt::Exit(1);
    }

    nnt::Exit(result);
}

