﻿# coding: UTF-8

import os
import subprocess
import sys
import testpath

APPLICATION_ID              = '0x0005000C10000000'

def devMenuCommand(args, argsDevMenu = []):
    subprocess.check_output([testpath.RUN_ON_TARGET_PATH, testpath.DEV_MENU_COMMAND_PATH] + argsDevMenu + ['--'] + args)

def installApplication(applicationPath):
    devMenuCommand(['application', 'install', applicationPath, '--force'])

def installPatch(patchPath):
    devMenuCommand(['patch', 'install', patchPath])

def launchTest():
    output = subprocess.check_output([testpath.RUN_ON_TARGET_PATH, APPLICATION_ID, '--pattern-failure-exit', '"Assert|Break|Panic|Halt|Fatal|Exception|Error"', '--', testpath.ROM_RESOURCE_DIRECTORY_PATH])
    isOutputPerformance = False
    for line in output.split('\n'):
        if isOutputPerformance:
            if line.startswith('[       OK ]'):
                break
            print line
        else:
            if line == '[ RUN      ] PerformanceTestReadPatch.ReadFile':
                isOutputPerformance = True
    sys.stdout.flush()

def uninstallApplication():
    devMenuCommand(['patch', 'uninstall', APPLICATION_ID, 'application', 'uninstall', APPLICATION_ID, 'AND', 'application', 'reset-required-version', '--all'])

