﻿# coding: UTF-8

import os
import random
import sys

sys.path.append(os.path.dirname(os.path.abspath(__file__)) + '/../../PatchCommon')
import execute
import makerom
import romfs
import patchtest

def main():
    platform = 'NX-NXFP2-a64'
    buildType = 'Release'
    endVersion = 4
    applicationMedia = "builtin"
    patchMedia = "builtin"

    argv = sys.argv
    if len(argv) >= 2:
        platform = argv[1]
    if platform.startswith('NXFP2-a'):
        platform = 'NX-' + platform # NXFP2-aXX → NX-NXFP2-aXX
    if len(argv) >= 3:
        buildType = argv[2]
    if len(argv) >= 4:
        endVersion = int(argv[3])
    if endVersion < 0:
        sys.exit(1)
    if len(argv) >= 5:
        execute.setTargetAddress(argv[4])
    if len(argv) >= 6:
        applicationMedia = argv[5]
    if len(argv) >= 7:
        patchMedia = argv[6]
    if not execute.checkMediaCombination(applicationMedia, patchMedia):
        sys.exit(1)

    random.seed(0)

    patchtest.updatePath(platform, buildType, 'PerformanceReadPatchSmallAlignment')

    execute.setupSdCard(applicationMedia, patchMedia)
    execute.uninstallApplication()

    romfs.initializeResourceDirectory()
    romfs.createResource()

    # オリジナル
    nspPath = makerom.createOriginalNsp()
    execute.setupApplication(nspPath, applicationMedia)
    patchtest.printf('Test version 0')
    execute.launchTest('PerformanceTestReadPatchReal.ReadFile', [patchtest.g_ResourceDirectoryPath])

    # パッチ（endVersion に関わらず必ず実行）
    romfs.updateResource()
    romfs.shiftFile()

    makerom.g_NspExtension = '_shift4.nsp'
    patchPath4 = makerom.makePatchWithOriginal(nspPath, 1, 4)
    execute.setupPatch(nspPath, patchPath4, patchMedia)
    patchtest.printf('Test version 1 (shift = 4)')
    execute.launchTest('PerformanceTestReadPatchReal.ReadFile', [patchtest.g_ResourceDirectoryPath])

    makerom.g_NspExtension = '_shift1.nsp'
    patchPath1 = makerom.makePatchWithOriginal(nspPath, 1, 1)
    execute.setupPatch(nspPath, patchPath1, patchMedia)
    patchtest.printf('Test version 1 (shift = 1)')
    execute.launchTest('PerformanceTestReadPatchReal.ReadFile', [patchtest.g_ResourceDirectoryPath])

    # 最適化パッチ
    for i in range(2, endVersion):
        romfs.updateResource()
        romfs.shiftFile()

        makerom.g_NspExtension = '_shift4.nsp'
        makerom.makePatchWithOriginal(nspPath, i, 4)
        patchPath4 = makerom.optimizePatch(i, 0, 4)
        execute.setupPatch(nspPath, patchPath4, patchMedia)
        patchtest.printf('Test version %d (shift = 4)' % i)
        execute.launchTest('PerformanceTestReadPatchReal.ReadFile', [patchtest.g_ResourceDirectoryPath])

        makerom.g_NspExtension = '_shift1.nsp'
        makerom.makePatchWithOriginal(nspPath, i, 1)
        patchPath1 = makerom.optimizePatch(i, 0, 1)
        execute.setupPatch(nspPath, patchPath1, patchMedia)
        patchtest.printf('Test version %d (shift = 1)' % i)
        execute.launchTest('PerformanceTestReadPatchReal.ReadFile', [patchtest.g_ResourceDirectoryPath])

    execute.uninstallApplication()

if __name__ == '__main__':
    main()
