﻿# coding: UTF-8

import os
import random
import sys
import shutil

sys.path.append(os.path.dirname(os.path.abspath(__file__)) + '/../../PatchCommon')
import execute
import makerom
import romfs
import patchtest

PERFORMANCE_TEST_NAME = 'PerformanceTestReadFixPosPatch.ReadFile'

def makeChangePattern(filePath):
    fileSize = os.path.getsize(filePath)
    patternList = list()
    position = 0
    while position < fileSize:
        span = random.randint(1024, 4 * 1024) * 16
        updateSize = random.randint(1, 5) * 16
        repeatCount = random.randint(2, 10)
        patternList.append([span, updateSize, repeatCount])
        position += (span + updateSize) * repeatCount
    return patternList

def changeFileRandom(filePath, patternList):
    with open(filePath, 'r+b') as outputFile:
        fileSize = os.path.getsize(filePath)
        for pattern in patternList:
            span = pattern[0]
            updateSize = pattern[1]
            repeatCount = pattern[2]
            for i in range(repeatCount):
                position = outputFile.tell()
                position += span
                if position >= fileSize:
                    return
                outputFile.seek(position)
                outputFile.write(romfs.getRandomBytes(min(updateSize, fileSize - position)))

def main():
    platform = 'NX-NXFP2-a64'
    buildType = 'Release'
    fileSize = 64 * 1024 * 1024
    endVersion = 4
    applicationMedia = "builtin"
    patchMedia = "builtin"

    argv = sys.argv
    if len(argv) >= 2:
        platform = argv[1]
    if len(argv) >= 3:
        buildType = argv[2]
    if platform.startswith('NXFP2-a'):
        platform = 'NX-' + platform # NXFP2-aXX → NX-NXFP2-aXX
    if len(argv) >= 4:
        endVersion = int(argv[3])
    if endVersion < 0:
        sys.exit(1)
    if len(argv) >= 5:
        execute.setTargetAddress(argv[4])
    if len(argv) >= 6:
        applicationMedia = argv[5]
    if len(argv) >= 7:
        patchMedia = argv[6]
    if not execute.checkMediaCombination(applicationMedia, patchMedia):
        sys.exit(1)

    random.seed(0)

    patchtest.updatePath(platform, buildType, 'PerformanceReadFixPosPatch')

    execute.setupSdCard(applicationMedia, patchMedia)
    execute.uninstallApplication()

    romfs.initializeResourceDirectory()
    romResourceFilePath = patchtest.g_ResourceDirectoryPath + '/1'
    romfs.createFile(romResourceFilePath, fileSize)

    # v0
    patchtest.printf('v0')
    v0NspPath = makerom.createOriginalNsp()
    execute.setupApplication(v0NspPath, applicationMedia)
    execute.launchTest(PERFORMANCE_TEST_NAME, [])

    if endVersion > 0:
        changePatternList = makeChangePattern(romResourceFilePath)

        # v1
        patchtest.printf('v1')
        changeFileRandom(romResourceFilePath, changePatternList)
        v1PatchPath = makerom.makePatch(1)
        execute.setupPatch(v0NspPath, v1PatchPath, patchMedia)
        execute.launchTest(PERFORMANCE_TEST_NAME, [])

        # v2~
        previousPatchPath = v1PatchPath
        for version in range(2, endVersion + 1):
            patchtest.printf('v%d', version)

            changeFileRandom(romResourceFilePath, changePatternList)
            makerom.makePatch(version)
            optimizedPatchPath = makerom.optimizePatch(version)
            execute.setupPatch(v0NspPath, optimizedPatchPath, patchMedia)
            execute.launchTest(PERFORMANCE_TEST_NAME, [])

    execute.uninstallApplication()

if __name__ == '__main__':
    main()

