﻿# coding: UTF-8

import os
import random
import sys
import shutil

sys.path.append(os.path.dirname(os.path.abspath(__file__)) + '/../../PatchCommon')
import execute
import makerom
import romfs
import patchtest

PERFORMANCE_TEST_NAME = 'PerformanceTestReadPatch.ReadFile'

def changeFileRandom(filePath, count):
    with open(filePath, 'r+b') as outputFile:
        stride = 1042 * 1024
        updateSize = 40 * 1024
        fileSize = os.path.getsize(filePath)
        offset = stride - (updateSize * count)
        while offset + updateSize <= fileSize:
            outputFile.seek(offset)
            outputFile.write(romfs.getRandomBytes(updateSize))
            offset += stride

def main():
    platform = 'NX-NXFP2-a64'
    buildType = 'Release'
    fileSize = 64 * 1024 * 1024
    endVersion = 4
    applicationMedia = "builtin"
    patchMedia = "builtin"

    argv = sys.argv
    if len(argv) >= 2:
        platform = argv[1]
    if len(argv) >= 3:
        buildType = argv[2]
    if platform.startswith('NXFP2-a'):
        platform = 'NX-' + platform # NXFP2-aXX → NX-NXFP2-aXX
    if len(argv) >= 4:
        endVersion = int(argv[3])
    if endVersion < 0:
        sys.exit(1)
    if len(argv) >= 5:
        execute.setTargetAddress(argv[4])
    if len(argv) >= 6:
        applicationMedia = argv[5]
    if len(argv) >= 7:
        patchMedia = argv[6]
    if not execute.checkMediaCombination(applicationMedia, patchMedia):
        sys.exit(1)

    random.seed(0)

    patchtest.updatePath(platform, buildType, 'PerformanceReadDefragmentedPatch')

    execute.setupSdCard(applicationMedia, patchMedia)
    execute.uninstallApplication()

    romfs.initializeResourceDirectory()
    romResourceFilePath = patchtest.g_ResourceDirectoryPath + '/1'
    romfs.createFile(romResourceFilePath, fileSize)

    # v0
    patchtest.printf('v0')
    v0NspPath = makerom.createOriginalNsp()
    execute.setupApplication(v0NspPath, applicationMedia)
    execute.launchTest(PERFORMANCE_TEST_NAME, [])

    # v1
    patchtest.printf('v1')
    changeFileRandom(romResourceFilePath, 1)
    v1PatchPath = makerom.makePatch(1)
    execute.setupPatch(v0NspPath, v1PatchPath, patchMedia)
    execute.launchTest(PERFORMANCE_TEST_NAME, [])

    # v2~
    for version in range(2, endVersion + 1):
        changeFileRandom(romResourceFilePath, version)
        makerom.makePatch(version)

        if version % 5 == 0:
             optimizedPatchPath, defragmentedPatchPath = makerom.optimizePatch(version, 512)

             patchtest.printf('v%d', version)
             execute.setupPatch(v0NspPath, optimizedPatchPath, patchMedia)
             execute.launchTest(PERFORMANCE_TEST_NAME, [])

             patchtest.printf('v%d (defrag)', version)
             execute.setupPatch(v0NspPath, defragmentedPatchPath, patchMedia)
             execute.launchTest(PERFORMANCE_TEST_NAME, [])
        else:
             makerom.optimizePatch(version)

    execute.uninstallApplication()

if __name__ == '__main__':
    main()

