﻿# coding: UTF-8

import os
import sys
import random
import shutil
import patchtest
import glob
import errno

BUFFER_SIZE = 1024 * 1024
g_FileList = []

# mkdir -p 同等品
def mkdir_p(path):
    try:
        os.makedirs(path)
    except OSError as exc:  # Python >2.5
        if exc.errno == errno.EEXIST and os.path.isdir(path):
            pass
        else:
            raise

# ランダムなバイト列を取得
def getRandomBytes(size):
    return bytearray(map(lambda _ : random.randrange(256), range(size)))

# ファイルパスを取得
def getFilePath(num):
    return os.path.join(patchtest.g_ResourceDirectoryPath, '%04d.dat' % num)

# ランダムなファイルパスを取得
def getRandomFilePath():
    path = getFilePath(random.randrange(1000))
    while os.path.exists(path):
        path = getFilePath(random.randrange(1000))
    return path

# リソースディレクトリの初期化
def initializeResourceDirectory():
    if os.path.exists(patchtest.g_ResourceDirectoryPath):
        shutil.rmtree(patchtest.g_ResourceDirectoryPath)
    mkdir_p(patchtest.g_ResourceDirectoryPath)

# ファイルリストを更新
def updateFileList():
    global g_FileList
    g_FileList = glob.glob(os.path.join(patchtest.g_ResourceDirectoryPath, '*.dat'))

# リスト内のファイルパスを取得
def getPickupFilePath():
    global g_FileList
    path = g_FileList[random.randrange(len(g_FileList))]
    while os.path.exists(path) == False:
        path = g_FileList[random.randrange(len(g_FileList))]
    return path

# ファイルを作成（中身は乱数）
def createFile(filePath, size):
    with open(filePath, 'wb') as outputFile:
        while outputFile.tell() < size:
            bufferSize = min(size - outputFile.tell(), BUFFER_SIZE)
            outputFile.write(getRandomBytes(bufferSize))

# ランダムなサイズのファイルを作成（中身は乱数）
def createFileRandomSize(filePath):
    size = 0
    while size < 1024 or 10 * 1024 * 1025 < size:
        value = random.lognormvariate(0.5, 0.8)
        size = int(value * 1024 * 1024)
    createFile(filePath, size)

# いずれかのファイルを 16 バイト未満ずらす
def shiftFile():
    updateFileList()

    filePath = getPickupFilePath()
    tempPath = filePath + '.tmp'
    os.rename(filePath, tempPath)

    with open(tempPath, mode = 'rb') as inputFile, open(filePath, mode = 'wb') as outputFile:
        outputFile.write(getRandomBytes(random.randrange(1, 16)))
        outputFile.write(inputFile.read())

    os.remove(tempPath)

# リソースの生成
def createResource():
    if os.path.exists(patchtest.g_ResourceDirectoryPath):
        shutil.rmtree(patchtest.g_ResourceDirectoryPath)
    os.mkdir(patchtest.g_ResourceDirectoryPath)

    for i in range(100):
        if (i % 10) == 0:
            patchtest.printf('create %04d.dat ... %04d.dat', i * 10, (i + 9) * 10)
        createFileRandomSize(getFilePath(i * 10))

# ファイルの更新
def updateFile(filePath, fileSize, updateSize, position, isUpdated):
    tempPath = filePath + '.tmp'
    os.rename(filePath, tempPath)

    with open(tempPath, mode = 'rb') as inputFile, open(filePath, mode = 'wb') as outputFile:
        # ファイルの前半をコピー
        outputFile.write(inputFile.read(position))

        if isUpdated:
            outputFile.write(getRandomBytes(updateSize))

        endPosition = position + updateSize

        # ファイルの後半をコピー
        if endPosition < fileSize:
            inputFile.seek(endPosition)
            outputFile.write(inputFile.read(fileSize - endPosition))

    os.remove(tempPath)

# リソースの更新
def updateResource():
    updateFileList()

    # ファイルのリネーム
    for i in range(random.randrange(1, 3)):
        oldFilePath = getPickupFilePath()
        newFilePath = getRandomFilePath()
        patchtest.printf('rename %s > %s', os.path.basename(oldFilePath), os.path.basename(newFilePath))
        os.rename(oldFilePath, newFilePath)

    # ファイルの追加
    for i in range(random.randrange(2, 8)):
        filePath = getRandomFilePath()
        patchtest.printf('create %s', os.path.basename(filePath))
        createFileRandomSize(filePath)

    # ファイルの削除
    for i in range(random.randrange(1, 4)):
        filePath = getPickupFilePath()
        patchtest.printf('remove %s', os.path.basename(filePath))
        os.remove(filePath)

    # ファイルの更新
    for i in range(random.randrange(10, 20)):
        filePath = getPickupFilePath()
        fileSize = os.path.getsize(filePath)
        updateSize = random.randrange(fileSize / 4 * 3) - fileSize / 4
        if updateSize != 0:
            position = random.randrange(1024, fileSize - 1024)
            patchtest.printf('update %s', os.path.basename(filePath))
            if updateSize < 0:
                updateFile(filePath, fileSize, -updateSize, position, False)
            else:
                updateFile(filePath, fileSize, updateSize, position, True)
