﻿# coding: UTF-8

import os
import subprocess
import sys
import patchtest
import time

APPLICATION_ID = '0x0005000C10000000'

g_targetAddress = ''

def checkMediaType(media):
    if media == "gamecard" or media == "sdcard" or media == "builtin":
        return True
    return False

def checkMediaCombination(applicationMedia, patchMedia):
    if not checkMediaType(applicationMedia):
        print("unknown media type for application")
        return False
    if not checkMediaType(patchMedia):
        print("unknown media type for patch")
        return False
    if patchMedia == "gamecard" and applicationMedia != "gamecard":
        print "on-card-patch must be gamecard application"
        return False
    return True

def setTargetAddress(address):
    global g_targetAddress
    g_targetAddress = address

def devMenuCommand(args, argsRunOnTarget = []):
    argsActual = [patchtest.RUN_ON_TARGET_PATH]
    if g_targetAddress:
        argsActual += ["--target", g_targetAddress]
    argsActual += ([patchtest.g_DevMenuCommandPath] + argsRunOnTarget + ['--'] + args)
    return subprocess.check_output(argsActual)

def formatSdCard():
    devMenuCommand(['sdcard', 'format'])
    subprocess.check_output([patchtest.CONTROL_TARGET_PATH, 'reset'])
    time.sleep(20) # 起動待ち

def installApplication(applicationPath, media="builtin"):
    devMenuCommand(['application', 'install', applicationPath, '--force', '-s', media])

def installPatch(patchPath, media='builtin'):
    devMenuCommand(['patch', 'install', patchPath, '-s', media])

def writeApplication(applicationPath, patchPath):
    if patchPath:
        devMenuCommand(['gamecard', 'write', applicationPath, '--on-card-patch', patchPath])
    else:
        devMenuCommand(['gamecard', 'write', applicationPath])

def setupSdCard(applicationMedia, patchMedia):
    if applicationMedia == "sdcard" or patchMedia == "sdcard":
        formatSdCard()

def setupApplication(applicationPath, media):
    if media == "gamecard":
        writeApplication(applicationPath, "")
    else:
        installApplication(applicationPath, media)

def setupPatch(applicationPath, patchPath, media):
    if media == "gamecard":
        writeApplication(applicationPath, patchPath)
    else:
        installPatch(patchPath, media)

def launchTest(performanceTestName, args):
    argsActual = [patchtest.RUN_ON_TARGET_PATH]
    if g_targetAddress:
        argsActual += ["--target", g_targetAddress]
    argsActual += [APPLICATION_ID, '--pattern-failure-exit', '"Assert|Break|Panic|Halt|Fatal|Exception|Error"', '--'] + args
    output = subprocess.check_output(argsActual)
    isOutputPerformance = False
    for line in output.split('\n'):
        if isOutputPerformance:
            if line.startswith('[       OK ]'):
                break
            print line
        else:
            if line == '[ RUN      ] ' + performanceTestName:
                isOutputPerformance = True
    sys.stdout.flush()

def uninstallApplication():
    res = devMenuCommand(['gamecard', 'status'])
    if not 'Not Inserted' in res:
        devMenuCommand(['gamecard', 'erase'])

    devMenuCommand(['patch', 'uninstall', APPLICATION_ID, 'application', 'uninstall', APPLICATION_ID, 'AND', 'application', 'reset-required-version', '--all'])

