﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs.h>

#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ns/ns_InitializationApi.h>
#include <nn/util/util_ScopeExit.h>

#include <nnt/nntest.h>
#include <nnt/result/testResult_Assert.h>

TEST(ApplyDeltaTest, Additional)
{
    nn::ncm::ApplicationId id = { 0x0005000c10000000 };

    nn::ns::Initialize();
    NN_UTIL_SCOPE_EXIT
    {
        nn::ns::Finalize();
    };

    NNT_ASSERT_RESULT_SUCCESS(nn::ns::MountApplicationHtmlDocument("htmlDoc", id));
    NN_UTIL_SCOPE_EXIT
    {
        nn::fs::Unmount("htmlDoc");
    };
    nn::fs::DirectoryEntryType entryType;
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::GetEntryType(&entryType, "htmlDoc:/html-document/document.txt"));

    EXPECT_EQ(nn::fs::DirectoryEntryType_File, entryType);
}
