﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>

#include <nnt/nntest.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/fsUtil/testFs_util.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/nnt_Argument.h>

using namespace nn;
using namespace nn::fs;
using namespace nn::fs::detail;
using namespace nnt::fs::util;

namespace {

TEST(KeyGeneration, DumpRom)
{
    size_t size;
    NNT_EXPECT_RESULT_SUCCESS(QueryMountRomCacheSize(&size));

    auto buffer = AllocateBuffer(size);
    ASSERT_NE(nullptr, buffer);

    const size_t WorkBufferSize = 64 * 1024 * 1024;
    auto workBuffer = AllocateBuffer(WorkBufferSize);

    NNT_ASSERT_RESULT_SUCCESS(MountRom("rom", buffer.get(), size));
    NNT_EXPECT_RESULT_SUCCESS(DumpDirectoryRecursive("rom:/", true, workBuffer.get(), WorkBufferSize));

    Unmount("rom");
    EXPECT_FALSE(nnt::fs::util::CheckMemoryLeak());
}

}

extern "C" void nnMain()
{
    int     argc = nn::os::GetHostArgc();
    char**  argv = nn::os::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

    nn::fs::SetAllocator(nnt::fs::util::Allocate, nnt::fs::util::Deallocate);
    nnt::fs::util::ResetAllocateCount();

    auto result = RUN_ALL_TESTS();

    if (nnt::fs::util::CheckMemoryLeak())
    {
        nnt::Exit(1);
    }

    nnt::Exit(result);
}

