﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs.h>
#include <nnt/fsUtil/testFs_util.h>

#include "testFs_Integration_AgingRw_IFileSystemProvider.h"
#include "testFs_Integration_AgingRw_TestStat.h"

// TODO: これも ITestCaseFunction 的なものにする？
using TestCaseFunction = void(*)(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);

// fs 内を DumpDirectoryRecursive する
void TestCaseReadOnlyDumpDirectoryRecursive(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);

// fs 内のファイルをランダムに選びランダムなレンジで read する
void TestCaseReadOnlyRandom(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);

// fs 内のファイルをランダムに選びランダムなレンジで read + verify / write する
void TestCaseReadWriteRandom(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);

// fs 内のファイルにランダムに 32bit カウントデータを書き込みんだ後ランダムに Read して verify する
void TestCaseReadWriteWith32BitCount(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);

// fs 内のファイルをランダムに選びランダムなレンジで read したあと 32Bit カウントデータで verify する
void TestCaseReadOnlyRandomWith32BitCountCheck(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);

// fs 内のファイルをランダムに選びランダムなレンジで read したあと 32Bit カウントデータで verify する。ファイル名のハッシュがオフセットになっている場合こっちを使う
void TestCaseReadOnlyRandomWith32BitCountCheckByFileNameOffset(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);

// C:/Windows/temp/dataSrc にランダムなディレクトリツリーを生成する
void TestCreateRandomDirectoryTree(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);

// パッチテスト向けに C:/Windows/temp/dataSrc のディレクトリツリーを乱す
void TestDisturbDirectoryTreeForPatchTest(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);

// コーナーケースシリーズ

// fs 内のファイルをランダムに選び、コーナーになりそうな オフセット・サイズで read する
void TestCaseReadOnlyRandomAtCorner(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);

// fs 内のファイルをランダムに選びランダムなレンジで read + verify / write する
void TestCaseReadWriteRandomAtCorner(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);

// fs 内のファイルをランダムに選びランダムなレンジで read + verify / write して commit
void TestCaseReadWriteCommitRandomAtCorner(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);

// fs 内のファイルにランダムに 32bit カウントデータを書き込みんだ後ランダムに Read して verify する
void TestCaseReadWriteWith32BitCountAtCorner(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);

// fs 内のファイルをランダムに選びランダムなレンジで read したあと 32Bit カウントデータで verify する
void TestCaseReadOnlyRandomWith32BitCountCheckAtCorner(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);

// fs 内のファイルをランダムに選びランダムなレンジで read したあと 32Bit カウントデータで verify する。ファイル名のハッシュがオフセットになっている場合こっちを使う
void TestCaseReadOnlyRandomWith32BitCountCheckAtCornerByFileNameOffset(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);

// fs 内のファイルをランダムに選び削除、作成する
void TestCaseCreateDeleteRandom(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder, int64_t totalSize, int64_t totalEntryCount, bool isCommit);

void TestCaseCreateDeleteRandom(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);

// バッファ枯渇パラメータ
// TODO: 別の方法でパラメータ注入
void TestCaseReadOnlyRandomLargeAccessSize(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);
void TestCaseReadOnlyRandomWith32BitCountCheckAtCornerByFileNameOffsetLargeAccessSize(IFileSystemProvider* pFsProvider, TestStatHolder* pTestStatHolder);


void AllocateTestParameterTlsSlot();
void SetMaxDirectoryTreeSize(int64_t size);
void SetBufferSizeForIndividualFileDataCache(size_t size) NN_NOEXCEPT;
