﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account.h>
#include <nn/fs/fs_ResultHandler.h>

#include <nnt/nnt_Argument.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/fsUtil/testFs_util.h>

namespace
{
    nn::account::Uid g_AccountUid;

    void SetUp() NN_NOEXCEPT
    {
        nn::Result result;
        g_AccountUid = nn::account::InvalidUid;
        int userCount = 0;
        result = nn::account::ListAllUsers(&userCount, &g_AccountUid, 1);
        NN_ASSERT(result.IsSuccess() && userCount > 0);
    }

    const nnt::fs::util::MountTestAttribute GetAttribute() NN_NOEXCEPT
    {
        nnt::fs::util::MountTestAttribute attribute = {};
        attribute.setUp = SetUp;
        return attribute;
    }

    // FsLibMountTest の SaveData にもテストあり

    // Result MountSystemSaveData(const char* name, SystemSaveDataId id, const nn::account::Uid& user)
    nn::Result MountSystemSaveDataType5ForMountNameTest(const char* mountName) NN_NOEXCEPT
    {
        NN_RESULT_DO(nnt::fs::util::CreateAndMountSystemSaveData(mountName, 0x8000000000000001, g_AccountUid));
        NN_RESULT_SUCCESS;
    }

    const nnt::fs::util::MountTestParameter MountTestParameters[] = {
        { "MountSystemSaveDataType5", MountSystemSaveDataType5ForMountNameTest, nullptr, GetAttribute },
    };
}

namespace nnt { namespace fs { namespace util {
    NNT_FS_INSTANTIATE_TEST_CASE_MOUNT(WithMountSaveData3, ::testing::ValuesIn(MountTestParameters));
}}}

extern "C" void nnMain()
{
    nnt::fs::util::LoadMountTest();

    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);
    nnt::fs::util::mock::InitializeForFsTest(&argc, argv);

    // アカウントライブラリを初期化
    nn::account::Initialize();

    nn::fs::SetAllocator(nnt::fs::util::Allocate, nnt::fs::util::Deallocate);
    nn::fs::SetEnabledAutoAbort(false);
    nnt::fs::util::ResetAllocateCount();

    auto result = RUN_ALL_TESTS();

    if (nnt::fs::util::CheckMemoryLeak())
    {
        nnt::Exit(1);
    }

    nnt::Exit(result);
}
