﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/aoc.h>
#include <nn/fs/fs_AddOnContent.h>
#include <nn/fs/fs_ResultHandler.h>

#include <nnt/nnt_Argument.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/fsUtil/testFs_util.h>

#include <nnt/fsUtil/testFs_util_GlobalNewDeleteChecker.Impl.h>

namespace
{
    decltype(nnt::fs::util::AllocateBuffer(0)) g_Buffer(nullptr, nnt::fs::util::DeleterBuffer);

    // Result MountAddOnContent(
    //     const char* name,
    //     nn::aoc::AddOnContentIndex targetIndex,
    //     void* pFileSystemCacheBuffer,
    //     size_t fileSystemCacheBufferSize
    // )
    nn::Result MountAddOnContentType1ForMountNameTest(const char* mountName) NN_NOEXCEPT
    {
        size_t size;
        NN_RESULT_DO(nn::fs::QueryMountAddOnContentCacheSize(&size, 1));
        g_Buffer = nnt::fs::util::AllocateBuffer(size);

        NN_RESULT_DO(nn::fs::MountAddOnContent(mountName, 1, g_Buffer.get(), size));
        NN_RESULT_SUCCESS;
    }

    const nnt::fs::util::MountTestParameter MountTestParameters[] = {
        { "MountAddOnContentType1", MountAddOnContentType1ForMountNameTest },
    };
}

namespace nnt { namespace fs { namespace util {
    NNT_FS_INSTANTIATE_TEST_CASE_MOUNT(WithMountData2, ::testing::ValuesIn(MountTestParameters));
}}}

extern "C" void nnMain()
{
    nnt::fs::util::LoadMountTest();

    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);
    nnt::fs::util::mock::InitializeForFsTest(&argc, argv);

    nn::fs::SetAllocator(nnt::fs::util::Allocate, nnt::fs::util::Deallocate);
    nn::fs::SetEnabledAutoAbort(false);
    nnt::fs::util::ResetAllocateCount();

    auto result = RUN_ALL_TESTS();

    if (nnt::fs::util::CheckMemoryLeak())
    {
        nnt::Exit(1);
    }

    nnt::Exit(result);
}
