﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_SdCardForDebug.h>
#include <nn/fs/fs_SdCardPrivate.h>

#include "testFs_FsLib_Mount.h"

TEST(MountSdCardTest, MountSdCard)
{
    NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountSdCardForDebug("sdcard"));

    NNT_EXPECT_RESULT_SUCCESS(nnt::fs::util::DeleteFileOrDirectoryIfExists("sdcard:/test.file"));
    NNT_EXPECT_RESULT_SUCCESS(nn::fs::CreateFile("sdcard:/test.file", 1024));
    NNT_EXPECT_RESULT_SUCCESS(nnt::fs::util::DumpDirectoryRecursive("sdcard:/"));
    NNT_EXPECT_RESULT_SUCCESS(nn::fs::DeleteFile("sdcard:/test.file"));

    NNT_EXPECT_RESULT_FAILURE(nn::fs::ResultMountNameAlreadyExists, nn::fs::MountSdCardForDebug("sdcard"));
    nn::fs::Unmount("sdcard");

    NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountSdCardForDebug("sdcard"));
    ValidateFileSystem("sdcard:/");
    nn::fs::Unmount("sdcard");

    NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountSdCardForDebug("sdcard"));
    ValidateFileSystem("sdcard:/");
    nn::fs::Unmount("sdcard");
}

namespace
{
    nn::Result MountSdCardForDebugForMountNameTest(const char* mountName) NN_NOEXCEPT
    {
        NN_RESULT_DO(nn::fs::MountSdCardForDebug(mountName));
        NN_RESULT_SUCCESS;
    }

    nn::Result MountSdCardForMountNameTest(const char* mountName) NN_NOEXCEPT
    {
        NN_RESULT_DO(nn::fs::MountSdCard(mountName));
        NN_RESULT_SUCCESS;
    }

    const nnt::fs::util::MountTestParameter MountTestParameters[] = {
        { "MountSdCardForDebug", MountSdCardForDebugForMountNameTest, nullptr },
        { "MountSdCard", MountSdCardForMountNameTest, nullptr },
    };
}

NNT_FS_INSTANTIATE_TEST_CASE_MOUNT(WithMountSdCard, ::testing::ValuesIn(MountTestParameters));
